/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class RecipeEfficiencyBar {

    public static class Parameters {
        public final int renderX;
        public final int renderY;

        public Parameters(int renderX, int renderY) {
            this.renderX = renderX;
            this.renderY = renderY;
        }
    }

    private static class Data {
        final boolean hasActiveRecipe;
        final int efficiencyTicks;
        final int maxEfficiencyTicks;
        final long currentRecipeEu;
        final long baseRecipeEu;
        final long maxRecipeEu;

        private Data() {
            this.hasActiveRecipe = false;
            this.efficiencyTicks = 0;
            this.maxEfficiencyTicks = 0;
            this.currentRecipeEu = 0L;
            this.baseRecipeEu = 0L;
            this.maxRecipeEu = 0L;
        }

        private Data(int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu, long maxRecipeEu) {
            this.efficiencyTicks = efficiencyTicks;
            this.maxEfficiencyTicks = maxEfficiencyTicks;
            this.hasActiveRecipe = true;
            this.currentRecipeEu = currentRecipeEu;
            this.baseRecipeEu = baseRecipeEu;
            this.maxRecipeEu = maxRecipeEu;
        }
    }

    public static class Server
    implements GuiComponent.Server<Data> {
        private final Parameters params;
        private final CrafterComponent crafter;

        public Server(Parameters params, CrafterComponent crafter) {
            this.params = params;
            this.crafter = crafter;
        }

        @Override
        public Data copyData() {
            if (this.crafter.hasActiveRecipe()) {
                return new Data(this.crafter.getEfficiencyTicks(), this.crafter.getMaxEfficiencyTicks(), this.crafter.getCurrentRecipeEu(), this.crafter.getBaseRecipeEu(), this.crafter.getBehavior().getMaxRecipeEu());
            }
            return new Data();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            if (!this.crafter.hasActiveRecipe()) {
                return cachedData.hasActiveRecipe;
            }
            return this.crafter.getEfficiencyTicks() != cachedData.efficiencyTicks || this.crafter.getMaxEfficiencyTicks() != cachedData.maxEfficiencyTicks || this.crafter.getCurrentRecipeEu() != cachedData.currentRecipeEu || this.crafter.getBaseRecipeEu() != cachedData.baseRecipeEu || this.crafter.getBehavior().getMaxRecipeEu() != cachedData.maxRecipeEu;
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            if (this.crafter.hasActiveRecipe()) {
                buf.writeBoolean(true);
                buf.writeInt(this.crafter.getEfficiencyTicks());
                buf.writeInt(this.crafter.getMaxEfficiencyTicks());
                buf.writeLong(this.crafter.getCurrentRecipeEu());
                buf.writeLong(this.crafter.getBaseRecipeEu());
            } else {
                buf.writeBoolean(false);
            }
            buf.writeLong(this.crafter.getBehavior().getMaxRecipeEu());
        }

        @Override
        public class_2960 getId() {
            return GuiComponents.RECIPE_EFFICIENCY_BAR;
        }
    }
}

