/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.models;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.models.ForwardingCasingUnbakedModel;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineUnbakedModel;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockTankBER;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5616;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class MachineRendering {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static class_2960 getCasingModelId(MachineCasing casing) {
        return new MIIdentifier("machine_casing/" + casing.name);
    }

    public static class_1087 getCasingModel(MachineCasing casing) {
        return class_310.method_1551().method_1554().getModel(MachineRendering.getCasingModelId(casing));
    }

    public static void init() {
        for (BlockDefinition<?> blockDef : MIBlock.BLOCKS.values()) {
            Object obj = blockDef.asBlock();
            if (!(obj instanceof MachineBlock)) continue;
            MachineBlock machine = (MachineBlock)obj;
            MachineRendering.registerBer(machine);
        }
        PreparableModelLoadingPlugin.register(MachineRendering::prepareUnbakedModels, (modelsToResolve, pluginCtx) -> {
            for (MachineCasing casing : MachineCasings.registeredCasings.values()) {
                pluginCtx.addModels(new class_2960[]{MachineRendering.getCasingModelId(casing)});
            }
            pluginCtx.resolveModel().register(ctx -> {
                if (!ctx.id().method_12836().equals("modern_industrialization")) {
                    return null;
                }
                return (class_1100)modelsToResolve.get(ctx.id());
            });
        });
    }

    private static void registerBer(MachineBlock machine) {
        MachineBlockEntity blockEntity = machine.getBlockEntityInstance();
        class_2591 type = blockEntity.method_11017();
        if (blockEntity instanceof LargeTankMultiblockBlockEntity) {
            class_5616.method_32144((class_2591)type, MultiblockTankBER::new);
        } else if (blockEntity instanceof MultiblockMachineBlockEntity) {
            class_5616.method_32144((class_2591)type, MultiblockMachineBER::new);
        } else {
            class_5616.method_32144((class_2591)type, c -> new MachineBlockEntityRenderer(c));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static List<CompletableFuture<Pair<class_2960, @Nullable class_1100>>> startLoadingMachineModels(class_3300 resourceManager, Executor executor) {
        ArrayList<CompletableFuture<Pair<class_2960, @Nullable class_1100>>> futures = new ArrayList<CompletableFuture<Pair<class_2960, class_1100>>>();
        for (Map.Entry<String, MachineCasing> entry : MachineBlock.REGISTERED_MACHINES.entrySet()) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                block10: {
                    Pair pair;
                    block9: {
                        @Nullable String machine = (String)entry.getKey();
                        MachineCasing casing = (MachineCasing)entry.getValue();
                        BufferedReader resource = ((class_3298)resourceManager.method_14486((class_2960)new MIIdentifier("models/machine/" + machine + ".json")).get()).method_43039();
                        try {
                            pair = Pair.of((Object)((Object)new MIIdentifier("item/" + machine)), (Object)MachineUnbakedModel.deserialize(casing, resource));
                            if (resource == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (resource != null) {
                                    try {
                                        resource.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException exception) {
                                LOGGER.error("Failed to find machine model json for machine " + machine, (Throwable)exception);
                                break block10;
                            }
                            catch (RuntimeException exception) {
                                LOGGER.error("Failed to load machine model json for machine " + machine, (Throwable)exception);
                            }
                        }
                        resource.close();
                    }
                    return pair;
                }
                return null;
            }, executor));
        }
        return futures;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static List<CompletableFuture<Pair<class_2960, @Nullable class_1100>>> startLoadingCasingModels(class_3300 resourceManager, Executor executor) {
        ArrayList<CompletableFuture<Pair<class_2960, @Nullable class_1100>>> futures = new ArrayList<CompletableFuture<Pair<class_2960, class_1100>>>();
        for (MachineCasing casing : MachineCasings.registeredCasings.values()) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                Object unbakedModel;
                @Nullable class_2960 jsonLocation = MachineRendering.getCasingModelId(casing).method_45134(p -> "models/" + p + ".json");
                Optional resource = resourceManager.method_14486(jsonLocation);
                if (resource.isEmpty()) {
                    try {
                        unbakedModel = class_793.method_3430((String)"{\n    \"parent\": \"block/cube\",\n    \"textures\": {\n        \"side\": \"modern_industrialization:block/casings/%s/side\",\n        \"particle\": \"#side\",\n        \"up\": \"modern_industrialization:block/casings/%s/top\",\n        \"down\": \"modern_industrialization:block/casings/%s/bottom\",\n        \"north\": \"#side\",\n        \"south\": \"#side\",\n        \"west\": \"#side\",\n        \"east\": \"#side\"\n    }\n}\n".formatted(casing.name, casing.name, casing.name));
                    }
                    catch (RuntimeException exception) {
                        LOGGER.error("Failed to construct default casing model: " + casing.name, (Throwable)exception);
                        return null;
                    }
                }
                try (BufferedReader stream = ((class_3298)resource.get()).method_43039();){
                    JsonObject json = JsonParser.parseReader((Reader)stream).getAsJsonObject();
                    String blockId = class_3518.method_15265((JsonObject)json, (String)"block");
                    class_2248 block = (class_2248)class_7923.field_41175.method_17966(new class_2960(blockId)).orElseThrow(() -> new JsonSyntaxException("Expected \"block\" to be a block, was unknown string " + blockId));
                    unbakedModel = new ForwardingCasingUnbakedModel(block.method_9564());
                }
                catch (IOException exception) {
                    LOGGER.error("Failed to load casing model json for casing " + casing.name, (Throwable)exception);
                    return null;
                }
                catch (RuntimeException exception) {
                    LOGGER.error("Failed to parse casing model json for casing " + casing.name, (Throwable)exception);
                    return null;
                }
                return Pair.of((Object)MachineRendering.getCasingModelId(casing), (Object)unbakedModel);
            }, executor));
        }
        return futures;
    }

    private static CompletableFuture<Map<class_2960, class_1100>> prepareUnbakedModels(class_3300 resourceManager, Executor executor) {
        return CompletableFuture.completedFuture(Boolean.TRUE).thenComposeAsync(ignored -> {
            ArrayList<CompletableFuture<Pair<class_2960, @Nullable class_1100>>> modelFutures = new ArrayList<CompletableFuture<Pair<class_2960, class_1100>>>();
            modelFutures.addAll(MachineRendering.startLoadingMachineModels(resourceManager, executor));
            modelFutures.addAll(MachineRendering.startLoadingCasingModels(resourceManager, executor));
            return class_156.method_33791(modelFutures).thenApply(list -> list.stream().filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }, executor);
    }

    private MachineRendering() {
    }
}

