/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks.world;

import aztech.modern_industrialization.machines.multiblocks.world.ChunkEventListener;
import aztech.modern_industrialization.machines.multiblocks.world.ChunkPosMultiMap;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.server.MinecraftServer;

public class ChunkEventListeners {
    public static ChunkPosMultiMap<ChunkEventListener> listeners = new ChunkPosMultiMap();
    private static MinecraftServer server = null;

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            server = minecraftServer;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> {
            server = null;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> ChunkEventListeners.serverStopCleanup());
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            ChunkEventListeners.ensureServerThread();
            Set<ChunkEventListener> cels = listeners.get((class_1937)world, chunk.method_12004());
            if (cels != null) {
                for (ChunkEventListener cel : cels) {
                    cel.onLoad();
                }
            }
        });
        ServerChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            ChunkEventListeners.ensureServerThread();
            Set<ChunkEventListener> cels = listeners.get((class_1937)world, chunk.method_12004());
            if (cels != null) {
                for (ChunkEventListener cel : cels) {
                    cel.onUnload();
                }
            }
        });
    }

    public static void onBlockStateChange(class_1937 world, class_1923 chunkPos, class_2338 pos) {
        Set<ChunkEventListener> cels;
        if (server.method_18854() && (cels = listeners.get(world, chunkPos)) != null) {
            for (ChunkEventListener cel : cels) {
                cel.onBlockUpdate(pos);
            }
        }
    }

    private static void ensureServerThread() {
        if (!server.method_18854()) {
            throw new RuntimeException("Thread is not server thread!");
        }
    }

    private static void serverStopCleanup() {
        if (listeners.size() != 0) {
            listeners = new ChunkPosMultiMap();
        }
    }
}

