/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.recipe.builder.MIRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.SmeltingRecipeBuilder;

public final class SmeltingRecipes {
    public static void apply(MaterialBuilder.RecipeContext ctx) {
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.TINY_DUST, MIParts.NUGGET, 0.08);
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.CRUSHED_DUST, MIParts.INGOT, 0.7);
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.DUST, MIParts.INGOT, 0.7);
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.ORE, MIParts.INGOT, 0.7);
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.ORE_DEEPSLATE, MIParts.INGOT, 0.7);
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.RAW_METAL, MIParts.INGOT, 0.7);
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.ORE, MIParts.GEM, 0.7);
        SmeltingRecipeBuilder.smeltAndBlast(ctx, MIParts.ORE_DEEPSLATE, MIParts.GEM, 0.7);
    }

    public static void applyBlastFurnace(MaterialBuilder.RecipeContext ctx, boolean hotIngot, int eu, int duration) {
        if (hotIngot) {
            new MIRecipeBuilder(ctx, MIMachineRecipeTypes.BLAST_FURNACE, "dust", eu, duration).addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.HOT_INGOT, 1);
        } else {
            new MIRecipeBuilder(ctx, MIMachineRecipeTypes.BLAST_FURNACE, "dust", eu, duration).addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.INGOT, 1);
            new MIRecipeBuilder(ctx, MIMachineRecipeTypes.BLAST_FURNACE, "tiny_dust", eu, duration / 10).addTaggedPartInput(MIParts.TINY_DUST, 1).addPartOutput(MIParts.NUGGET, 1);
        }
    }

    public static void applyBlastFurnace(MaterialBuilder.RecipeContext ctx, boolean hotIngot, int eu) {
        SmeltingRecipes.applyBlastFurnace(ctx, hotIngot, eu, 200);
    }

    public static void applyBlastFurnace(MaterialBuilder.RecipeContext ctx, int eu) {
        SmeltingRecipes.applyBlastFurnace(ctx, false, eu);
    }

    public static void applyBlastFurnace(MaterialBuilder.RecipeContext ctx) {
        SmeltingRecipes.applyBlastFurnace(ctx, 32);
    }

    private SmeltingRecipes() {
    }
}

