/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class PipeMeshBuilder
extends PipePartBuilder {
    private static final RenderMaterial CUTOUT_MATERIAL = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(BlendMode.CUTOUT).ambientOcclusion(TriState.FALSE).find();
    protected final QuadEmitter emitter;
    private final class_1058 sprite;
    private final float spriteSizeU;
    private final float spriteSizeV;
    private static final double COL_WIDTH = 0.125;
    private static final double[] BEND_COL = new double[]{0.0, 0.125, 0.0, 0.25};
    private static final double[] BEND_CONFLICTING_COL = new double[]{0.0, 0.5, 0.0, 0.625};
    private static final double[] STRAIGHT_COL = new double[]{0.75, 0.75, 0.75, 0.75};
    private static final int[][] CENTER_PATTERNS = new int[][]{{1, 0, 1, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {1, 1, 1, 1}, {1, 0, 1, 1}, {0, 0, 0, 1}};
    private static final double[][] CENTER_UVS = new double[][]{{0.0, 0.0}, {0.125, 0.0}, {0.375, 0.0}, {0.375, 0.125}, {0.375, 0.25}, {0.375, 0.375}};

    PipeMeshBuilder(QuadEmitter emitter, int slotPos, class_2350 direction, class_1058 sprite) {
        super(slotPos, direction);
        this.emitter = emitter;
        this.sprite = sprite;
        this.spriteSizeU = sprite.method_4577() - sprite.method_4594();
        this.spriteSizeV = sprite.method_4575() - sprite.method_4593();
    }

    protected void quad(class_2350 direction, float left, float bottom, float right, float top, float depth) {
        this.emitter.square(direction, left, bottom, right, top, depth);
        this.emitter.cullFace(null);
        this.emitter.material(CUTOUT_MATERIAL);
    }

    private void quad(class_2350 direction, double left, double bottom, double right, double top, double depth) {
        this.quad(direction, (float)left, (float)bottom, (float)right, (float)top, (float)depth);
    }

    private void quad(class_243 facing, class_243[] corners, class_243[] uvs) {
        if (corners.length != 4 || uvs.length != 4) {
            throw new RuntimeException("This is a bug, please report!");
        }
        class_243 c1 = corners[0];
        class_243 c4 = corners[3];
        class_2350 direction = class_2350.method_10142((double)facing.field_1352, (double)facing.field_1351, (double)facing.field_1350);
        double x = Math.min(c1.field_1352, c4.field_1352);
        double y = Math.min(c1.field_1351, c4.field_1351);
        double z = Math.min(c1.field_1350, c4.field_1350);
        double X = Math.max(c1.field_1352, c4.field_1352);
        double Y = Math.max(c1.field_1351, c4.field_1351);
        double Z = Math.max(c1.field_1350, c4.field_1350);
        if (direction == class_2350.field_11036) {
            this.quad(class_2350.field_11036, x, 1.0 - Z, X, 1.0 - z, 1.0 - Y);
        } else if (direction == class_2350.field_11033) {
            this.quad(class_2350.field_11033, x, z, X, Z, y);
        } else if (direction == class_2350.field_11043) {
            this.quad(class_2350.field_11043, 1.0 - X, y, 1.0 - x, Y, z);
        } else if (direction == class_2350.field_11034) {
            this.quad(class_2350.field_11034, 1.0 - Z, y, 1.0 - z, Y, 1.0 - X);
        } else if (direction == class_2350.field_11035) {
            this.quad(class_2350.field_11035, x, y, X, Y, 1.0 - Z);
        } else {
            this.quad(class_2350.field_11039, z, y, Z, Y, x);
        }
        for (int i = 0; i < 4; ++i) {
            class_243 vertexPos = new class_243(this.emitter.copyPos(i, null));
            for (int j = 0; j < 4; ++j) {
                if (!(vertexPos.method_1020(corners[j]).method_1027() < 1.0E-6)) continue;
                float realU = this.sprite.method_4594() + this.spriteSizeU * (float)uvs[j].method_10216();
                float realV = this.sprite.method_4593() + this.spriteSizeV * (float)uvs[j].method_10214();
                this.emitter.uv(i, realU, realV);
            }
        }
        this.emitter.emit();
    }

    @Override
    void drawPipe(float length, PipePartBuilder.Intent intent, boolean end) {
        if ((double)length <= 1.0E-9) {
            return;
        }
        double[] cols = intent == PipePartBuilder.Intent.STRAIGHT ? STRAIGHT_COL : (intent == PipePartBuilder.Intent.BEND ? BEND_COL : BEND_CONFLICTING_COL);
        for (int i = 0; i < 4; ++i) {
            if (intent != PipePartBuilder.Intent.STRAIGHT && i == 0) {
                length -= 0.125f;
            }
            double u = cols[i];
            class_243 up = this.up();
            class_243 base = this.pos.method_1019(up.method_1021(0.0625));
            this.quad(up, new class_243[]{base.method_1019(this.right.method_1021(0.0625)), base.method_1020(this.right.method_1021(0.0625)), base.method_1019(this.right.method_1021(0.0625)).method_1019(this.facing.method_1021((double)length)), base.method_1020(this.right.method_1021(0.0625)).method_1019(this.facing.method_1021((double)length))}, new class_243[]{new class_243(u + 0.125, (double)length, 0.0), new class_243(u, (double)length, 0.0), new class_243(u + 0.125, 0.0, 0.0), new class_243(u, 0.0, 0.0)});
            this.rotateCw();
            if (intent == PipePartBuilder.Intent.STRAIGHT || i != 0) continue;
            length += 0.125f;
        }
        if (end) {
            class_243[] class_243Array;
            class_243 up = this.up();
            class_243 base = this.pos.method_1019(this.facing.method_1021((double)length));
            class_243[] class_243Array2 = new class_243[]{base.method_1020(up.method_1021(0.0625)).method_1020(this.right.method_1021(0.0625)), base.method_1020(up.method_1021(0.0625)).method_1019(this.right.method_1021(0.0625)), base.method_1019(up.method_1021(0.0625)).method_1020(this.right.method_1021(0.0625)), base.method_1019(up.method_1021(0.0625)).method_1019(this.right.method_1021(0.0625))};
            if (intent == PipePartBuilder.Intent.STRAIGHT) {
                class_243[] class_243Array3 = new class_243[4];
                class_243Array3[0] = new class_243(0.5, 0.0, 0.0);
                class_243Array3[1] = new class_243(0.375, 0.0, 0.0);
                class_243Array3[2] = new class_243(0.5, 0.125, 0.0);
                class_243Array = class_243Array3;
                class_243Array3[3] = new class_243(0.375, 0.125, 0.0);
            } else {
                class_243[] class_243Array4 = new class_243[4];
                class_243Array4[0] = new class_243(0.125, 1.0, 0.0);
                class_243Array4[1] = new class_243(0.0, 1.0, 0.0);
                class_243Array4[2] = new class_243(0.125, 0.875, 0.0);
                class_243Array = class_243Array4;
                class_243Array4[3] = new class_243(0.0, 0.875, 0.0);
            }
            this.quad(this.facing, class_243Array2, class_243Array);
        }
    }

    void noConnection(int directions) {
        int i;
        if ((directions & 1 << class_2350.method_10142((double)this.facing.field_1352, (double)this.facing.field_1351, (double)this.facing.field_1350).method_10146()) > 0) {
            return;
        }
        int[] sidesDirections = new int[4];
        for (i = 0; i < 4; ++i) {
            class_243 up = this.up();
            class_2350 sideDir = class_2350.method_10142((double)up.field_1352, (double)up.field_1351, (double)up.field_1350);
            sidesDirections[i] = directions >> sideDir.method_10146() & 1;
            this.rotateCw();
        }
        for (i = 0; i < CENTER_PATTERNS.length; ++i) {
            block2: for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    if (CENTER_PATTERNS[i][k] != sidesDirections[(j + k) % 4]) continue block2;
                }
                class_243 up = this.up();
                class_243[] vertices = new class_243[]{this.pos.method_1019(this.right.method_1021(0.0625)).method_1020(up.method_1021(0.0625)), this.pos.method_1019(this.right.method_1021(0.0625)).method_1019(up.method_1021(0.0625)), this.pos.method_1020(this.right.method_1021(0.0625)).method_1020(up.method_1021(0.0625)), this.pos.method_1020(this.right.method_1021(0.0625)).method_1019(up.method_1021(0.0625))};
                double u = CENTER_UVS[i][0];
                double v = CENTER_UVS[i][1];
                class_243[] uvs = new class_243[]{new class_243(u, v + 0.125, 0.0), new class_243(u, v, 0.0), new class_243(u + 0.125, v + 0.125, 0.0), new class_243(u + 0.125, v, 0.0)};
                for (int k = 0; k < j; ++k) {
                    this.rotate(vertices);
                }
                this.quad(this.facing, vertices, uvs);
                return;
            }
        }
    }

    private void rotate(class_243[] arr) {
        class_243 tmp = arr[0];
        arr[0] = arr[2];
        arr[2] = arr[3];
        arr[3] = arr[1];
        arr[1] = tmp;
    }

    @Environment(value=EnvType.CLIENT)
    public static class InnerQuads
    extends PipeMeshBuilder {
        InnerQuads(QuadEmitter emitter, int slotPos, class_2350 direction, class_1058 sprite) {
            super(emitter, slotPos, direction, sprite);
        }

        @Override
        protected void quad(class_2350 direction, float left, float bottom, float right, float top, float depth) {
            super.quad(direction, left, bottom, right, top, depth + 0.001f);
            this.emitter.tag(1);
            this.emitter.emit();
            super.quad(direction, left, bottom, right, top, depth);
        }
    }
}

