/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.compat;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.api.ModSupport;
import net.pneumono.gravestones.content.entity.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.GravestoneCreation;

public class TrinketsSupport
extends ModSupport {
    @Override
    public void insertGravestoneData(class_1657 player, TechnicalGravestoneBlockEntity entity) {
        TrinketComponent trinketComponent = TrinketsApi.getTrinketComponent((class_1309)player).orElse(null);
        if (trinketComponent == null) {
            GravestoneCreation.logger("Player does not have trinkets, so no trinkets were inserted");
            return;
        }
        List<class_3545<SlotReferencePrimitive, class_1799>> filteredTrinkets = trinketComponent.getAllEquipped().stream().filter(pair -> class_1890.method_8225((class_1887)class_1893.field_9109, (class_1799)((class_1799)pair.method_15441())) == 0 && !GravestonesApi.shouldSkipItem(player, (class_1799)pair.method_15441())).map(pair -> {
            SlotType slotType = ((SlotReference)pair.method_15442()).inventory().getSlotType();
            SlotReferencePrimitive slotReferencePrimitive = new SlotReferencePrimitive(slotType.getGroup(), slotType.getName());
            return new class_3545((Object)slotReferencePrimitive, (Object)((class_1799)pair.method_15441()));
        }).toList();
        entity.addOrReplaceModData("trinkets", TrinketsSupport.serializeSlotData(filteredTrinkets));
        trinketComponent.getInventory().clear();
    }

    @Override
    public void onGravestoneBreak(TechnicalGravestoneBlockEntity entity) {
        class_1937 world = entity.method_10997();
        if (world != null && !world.method_8608()) {
            List<class_3545<SlotReferencePrimitive, class_1799>> gravestoneTrinkets = TrinketsSupport.deserializeSlotData(entity.getModData("trinkets"));
            class_2338 pos = entity.method_11016();
            for (class_3545<SlotReferencePrimitive, class_1799> pair : gravestoneTrinkets) {
                class_1542 item = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)pair.method_15441());
                world.method_8649((class_1297)item);
            }
        }
    }

    @Override
    public void onGravestoneCollect(class_1657 player, TechnicalGravestoneBlockEntity entity) {
        GravestoneCreation.logger("Returning trinkets...");
        class_1937 world = player.method_37908();
        class_2338 pos = entity.method_11016();
        List<class_3545<SlotReferencePrimitive, class_1799>> gravestoneTrinkets = TrinketsSupport.deserializeSlotData(entity.getModData("trinkets"));
        TrinketComponent playerTrinketComponent = TrinketsApi.getTrinketComponent((class_1309)player).orElse(null);
        for (class_3545<SlotReferencePrimitive, class_1799> pair : gravestoneTrinkets) {
            SlotReferencePrimitive slot;
            boolean moved;
            class_1799 stack = (class_1799)pair.method_15441();
            if (playerTrinketComponent != null && (moved = this.moveTrinketToPlayer(player, slot = (SlotReferencePrimitive)pair.method_15442(), stack))) continue;
            class_1542 item = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
            world.method_8649((class_1297)item);
        }
        entity.addOrReplaceModData("trinkets", new class_2487());
    }

    private boolean moveTrinketToPlayer(class_1657 player, SlotReferencePrimitive slot, class_1799 stack) {
        TrinketInventory playerTrinketInventory = this.getTrinketInventory(player, slot.groupName(), slot.slotName());
        if (playerTrinketInventory != null) {
            for (int i = 0; i < playerTrinketInventory.method_5439(); ++i) {
                if (!playerTrinketInventory.method_5438(i).method_7960()) continue;
                playerTrinketInventory.method_5447(i, stack);
                return true;
            }
        }
        return false;
    }

    private TrinketInventory getTrinketInventory(class_1657 player, String groupId, String slotId) {
        Map group;
        Optional optional = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optional.isPresent() && (group = (Map)((TrinketComponent)optional.get()).getInventory().get(groupId)) != null) {
            return (TrinketInventory)group.get(slotId);
        }
        return null;
    }

    public static class_2487 serializeSlotData(List<class_3545<SlotReferencePrimitive, class_1799>> slotData) {
        class_2487 compoundTag = new class_2487();
        class_2499 listTag = new class_2499();
        for (class_3545<SlotReferencePrimitive, class_1799> pair : slotData) {
            class_2487 slotTag = new class_2487();
            slotTag.method_10582("slotName", ((SlotReferencePrimitive)pair.method_15442()).slotName());
            slotTag.method_10582("groupName", ((SlotReferencePrimitive)pair.method_15442()).groupName());
            class_2487 itemStackTag = new class_2487();
            ((class_1799)pair.method_15441()).method_7953(itemStackTag);
            slotTag.method_10566("itemStack", (class_2520)itemStackTag);
            listTag.add((Object)slotTag);
        }
        compoundTag.method_10566("slotData", (class_2520)listTag);
        return compoundTag;
    }

    public static List<class_3545<SlotReferencePrimitive, class_1799>> deserializeSlotData(class_2487 compoundTag) {
        if (compoundTag == null) {
            GravestoneCreation.logger("Gravestone does not have trinkets, so no items were dropped");
            return new ArrayList<class_3545<SlotReferencePrimitive, class_1799>>();
        }
        ArrayList<class_3545<SlotReferencePrimitive, class_1799>> slotData = new ArrayList<class_3545<SlotReferencePrimitive, class_1799>>();
        class_2499 listTag = compoundTag.method_10554("slotData", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 slotTag = listTag.method_10602(i);
            String slotName = slotTag.method_10558("slotName");
            String groupName = slotTag.method_10558("groupName");
            SlotReferencePrimitive slotReference = new SlotReferencePrimitive(groupName, slotName);
            class_2487 itemStackTag = slotTag.method_10562("itemStack");
            class_1799 itemStack = class_1799.method_7915((class_2487)itemStackTag);
            slotData.add((class_3545<SlotReferencePrimitive, class_1799>)new class_3545((Object)slotReference, (Object)itemStack));
        }
        return slotData;
    }

    public record SlotReferencePrimitive(String groupName, String slotName) {
    }
}

