/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.program.IrisProgramTypes;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.irisshaders.iris.mixinterface.ShaderInstanceInterface;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.samplers.IrisSamplers;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_285;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3679;
import net.minecraft.class_5912;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ExtendedShader
extends class_5944
implements ShaderInstanceInterface {
    private static final Matrix4f identity = new Matrix4f();
    private static ExtendedShader lastApplied;
    private final boolean intensitySwizzle;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final boolean hasOverrides;
    private final class_284 modelViewInverse;
    private final class_284 projectionInverse;
    private final class_284 normalMatrix;
    private final CustomUniforms customUniforms;
    private final IrisRenderingPipeline parent;
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private final GlFramebuffer writingToBeforeTranslucent;
    private final GlFramebuffer writingToAfterTranslucent;
    private final BlendModeOverride blendModeOverride;
    float alphaTest;
    boolean usesTessellation;
    Matrix4f tempMatrix4f = new Matrix4f();
    Matrix3f tempMatrix3f = new Matrix3f();
    float[] tempFloats = new float[16];
    float[] tempFloats2 = new float[9];
    private class_281 geometry;
    private class_281 tessControl;
    private class_281 tessEval;

    public ExtendedShader(class_5912 resourceFactory, String string, class_293 vertexFormat, boolean usesTessellation, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, BlendModeOverride blendModeOverride, AlphaTest alphaTest, Consumer<DynamicLocationalUniformHolder> uniformCreator, BiConsumer<SamplerHolder, ImageHolder> samplerCreator, boolean isIntensity, IrisRenderingPipeline parent, @Nullable List<BufferBlendOverride> bufferBlendOverrides, CustomUniforms customUniforms) throws IOException {
        super(resourceFactory, string, vertexFormat);
        GLDebug.nameObject(33505, this.method_1274().method_34417(), string + "_vertex.vsh");
        GLDebug.nameObject(33505, this.method_1278().method_34417(), string + "_fragment.fsh");
        int programId = this.method_1270();
        GLDebug.nameObject(33506, programId, string);
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder(string, programId);
        ProgramSamplers.Builder samplerBuilder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        uniformCreator.accept(uniformBuilder);
        ProgramImages.Builder builder = ProgramImages.builder(programId);
        samplerCreator.accept(samplerBuilder, builder);
        customUniforms.mapholderToPass(uniformBuilder, this);
        this.usesTessellation = usesTessellation;
        this.uniforms = uniformBuilder.buildUniforms();
        this.customUniforms = customUniforms;
        this.samplers = samplerBuilder.build();
        this.images = builder.build();
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = bufferBlendOverrides;
        this.hasOverrides = bufferBlendOverrides != null && !bufferBlendOverrides.isEmpty();
        this.alphaTest = alphaTest.reference();
        this.parent = parent;
        this.modelViewInverse = this.method_34582("ModelViewMatInverse");
        this.projectionInverse = this.method_34582("ProjMatInverse");
        this.normalMatrix = this.method_34582("NormalMat");
        this.intensitySwizzle = isIntensity;
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    public void method_34585() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        lastApplied = null;
        if (this.blendModeOverride != null || this.hasOverrides) {
            BlendModeOverride.restore();
        }
        class_310.method_1551().method_1522().method_1235(false);
    }

    public void method_34586() {
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        if (lastApplied != this) {
            lastApplied = this;
            class_285.method_22094((int)this.method_1270());
        }
        if (this.intensitySwizzle) {
            IrisRenderSystem.texParameteriv(RenderSystem.getShaderTexture((int)0), TextureType.TEXTURE_2D.getGlType(), 36422, new int[]{6403, 6403, 6403, 6403});
        }
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 0, RenderSystem.getShaderTexture((int)0));
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 1, RenderSystem.getShaderTexture((int)1));
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 2, RenderSystem.getShaderTexture((int)2));
        ImmediateState.usingTessellation = this.usesTessellation;
        if (this.field_29471 != null) {
            if (this.projectionInverse != null) {
                this.projectionInverse.method_1253(this.tempMatrix4f.set(this.field_29471.method_35664()).invert().get(this.tempFloats));
            }
        } else if (this.projectionInverse != null) {
            this.projectionInverse.method_1250(identity);
        }
        if (this.field_29470 != null) {
            if (this.modelViewInverse != null) {
                this.modelViewInverse.method_1253(this.tempMatrix4f.set(this.field_29470.method_35664()).invert().get(this.tempFloats));
            }
            if (this.normalMatrix != null) {
                this.normalMatrix.method_1253(this.tempMatrix3f.set((Matrix4fc)this.tempMatrix4f.set(this.field_29470.method_35664())).invert().transpose().get(this.tempFloats2));
            }
        }
        this.uploadIfNotNull(this.projectionInverse);
        this.uploadIfNotNull(this.modelViewInverse);
        this.uploadIfNotNull(this.normalMatrix);
        List uniformList = this.field_29490;
        for (class_284 uniform : uniformList) {
            this.uploadIfNotNull(uniform);
        }
        this.samplers.update();
        this.uniforms.update();
        this.customUniforms.push(this);
        this.images.update();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.hasOverrides) {
            this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    @Nullable
    public class_284 method_34582(String name) {
        return super.method_34582("iris_" + name);
    }

    private void uploadIfNotNull(class_284 uniform) {
        if (uniform != null) {
            uniform.method_1300();
        }
    }

    public void method_34418() {
        super.method_34418();
        if (this.geometry != null) {
            this.geometry.method_1281((class_3679)this);
        }
        if (this.tessControl != null) {
            this.tessControl.method_1281((class_3679)this);
        }
        if (this.tessEval != null) {
            this.tessEval.method_1281((class_3679)this);
        }
    }

    @Override
    public void iris$createExtraShaders(class_5912 factory, String name) {
        factory.method_14486(new class_2960("minecraft", name + "_geometry.gsh")).ifPresent(geometry -> {
            try {
                this.geometry = class_281.method_1283((class_281.class_282)IrisProgramTypes.GEOMETRY, (String)name, (InputStream)geometry.method_14482(), (String)geometry.method_14480(), (class_5913)new class_5913(){

                    @Nullable
                    public String method_34233(boolean bl, String string) {
                        return null;
                    }
                });
                GLDebug.nameObject(33505, this.geometry.method_34417(), name + "_geometry.gsh");
            }
            catch (IOException e) {
                Iris.logger.error("Failed to create shader program", e);
            }
        });
        factory.method_14486(new class_2960("minecraft", name + "_tessControl.tcs")).ifPresent(tessControl -> {
            try {
                this.tessControl = class_281.method_1283((class_281.class_282)IrisProgramTypes.TESS_CONTROL, (String)name, (InputStream)tessControl.method_14482(), (String)tessControl.method_14480(), (class_5913)new class_5913(){

                    @Nullable
                    public String method_34233(boolean bl, String string) {
                        return null;
                    }
                });
                GLDebug.nameObject(33505, this.tessControl.method_34417(), name + "_tessControl.tcs");
            }
            catch (IOException e) {
                Iris.logger.error("Failed to create shader program", e);
            }
        });
        factory.method_14486(new class_2960("minecraft", name + "_tessEval.tes")).ifPresent(tessEval -> {
            try {
                this.tessEval = class_281.method_1283((class_281.class_282)IrisProgramTypes.TESS_EVAL, (String)name, (InputStream)tessEval.method_14482(), (String)tessEval.method_14480(), (class_5913)new class_5913(){

                    @Nullable
                    public String method_34233(boolean bl, String string) {
                        return null;
                    }
                });
                GLDebug.nameObject(33505, this.tessEval.method_34417(), name + "_tessEval.tes");
            }
            catch (IOException e) {
                Iris.logger.error("Failed to create shader program", e);
            }
        });
    }

    public class_281 getGeometry() {
        return this.geometry;
    }

    public class_281 getTessControl() {
        return this.tessControl;
    }

    public class_281 getTessEval() {
        return this.tessEval;
    }

    public boolean hasActiveImages() {
        return this.images.getActiveImages() > 0;
    }

    static {
        identity.identity();
    }
}

