/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import dan200.computercraft.core.util.Nullability;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialView;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class FoiledModel
extends ForwardingBakedModel
implements RenderContext.QuadTransform {
    private final @Nullable Renderer renderer = RendererAccess.INSTANCE.getRenderer();
    private @Nullable RenderMaterial lastMaterial;
    private @Nullable RenderMaterial lastFoiledMaterial;

    public FoiledModel(class_1087 model) {
        this.wrapped = model;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.pushTransform((RenderContext.QuadTransform)this);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.pushTransform((RenderContext.QuadTransform)this);
        super.emitItemQuads(stack, randomSupplier, context);
        context.popTransform();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FoiledModel)) return false;
        FoiledModel other = (FoiledModel)((Object)obj);
        if (!this.wrapped.equals(other.wrapped)) return false;
        return true;
    }

    public int hashCode() {
        return this.wrapped.hashCode() ^ 1;
    }

    public boolean transform(MutableQuadView quad) {
        if (this.renderer == null) {
            return true;
        }
        RenderMaterial material = quad.material();
        if (material == this.lastMaterial) {
            quad.material(Nullability.assertNonNull(this.lastFoiledMaterial));
        } else {
            this.lastMaterial = material;
            this.lastFoiledMaterial = this.renderer.materialFinder().copyFrom((MaterialView)material).glint(TriState.TRUE).find();
            quad.material(this.lastFoiledMaterial);
        }
        return true;
    }
}

