/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.Resource;
import dan200.computercraft.core.apis.http.ResourceGroup;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Future;
import org.jspecify.annotations.Nullable;

public class CheckUrl
extends Resource<CheckUrl> {
    private static final String EVENT = "http_check";
    private @Nullable Future<?> future;
    private final IAPIEnvironment environment;
    private final String address;
    private final URI uri;

    public CheckUrl(ResourceGroup<CheckUrl> limiter, IAPIEnvironment environment, String address, URI uri) {
        super(limiter);
        this.environment = environment;
        this.address = address;
        this.uri = uri;
    }

    public void run() {
        if (this.isClosed()) {
            return;
        }
        this.future = NetworkUtils.EXECUTOR.submit(this::doRun);
        this.checkClosed();
    }

    private void doRun() {
        block4: {
            if (this.isClosed()) {
                return;
            }
            try {
                boolean ssl = this.uri.getScheme().equalsIgnoreCase("https");
                InetSocketAddress netAddress = NetworkUtils.getAddress(this.uri, ssl);
                NetworkUtils.getOptions(this.uri.getHost(), netAddress);
                if (this.tryClose()) {
                    this.environment.queueEvent(EVENT, this.address, true);
                }
            }
            catch (HTTPRequestException e) {
                if (!this.tryClose()) break block4;
                this.environment.queueEvent(EVENT, this.address, false, NetworkUtils.toFriendlyError(e));
            }
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.future = CheckUrl.closeFuture(this.future);
    }
}

