/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.network.PacketNetwork;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.network.wired.WiredSender;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.NotAttachedException;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.computer.GuardedLuaContext;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.core.util.LuaUtil;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WiredModemPeripheral
extends ModemPeripheral
implements WiredSender {
    private static final Logger LOG = LoggerFactory.getLogger(WiredModemPeripheral.class);
    private final WiredModemElement modem;
    private final WiredModemLocalPeripheral localPeripheral;
    private final class_2586 target;
    private final Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> peripheralWrappers = new HashMap<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>>(1);

    public WiredModemPeripheral(ModemState state, WiredModemElement modem, WiredModemLocalPeripheral localPeripheral, class_2586 target) {
        super(state);
        this.modem = modem;
        this.localPeripheral = localPeripheral;
        this.target = target;
    }

    @Override
    public boolean isInterdimensional() {
        return true;
    }

    @Override
    public double getRange() {
        return 2.147483647E9;
    }

    @Override
    protected PacketNetwork getNetwork() {
        return this.modem.getNode();
    }

    @Override
    public class_1937 getLevel() {
        return this.modem.getLevel();
    }

    @Override
    public Set<String> getAdditionalTypes() {
        return Set.of("peripheral_hub");
    }

    @LuaFunction
    public final Collection<String> getNamesRemote(IComputerAccess computer) {
        ConcurrentMap<String, RemotePeripheralWrapper> wrappers = this.getWrappers(computer);
        return wrappers == null ? Set.of() : wrappers.keySet();
    }

    @LuaFunction
    public final boolean isPresentRemote(IComputerAccess computer, String name) {
        return this.getWrapper(computer, name) != null;
    }

    @LuaFunction
    public final Object @Nullable [] getTypeRemote(IComputerAccess computer, String name) {
        RemotePeripheralWrapper wrapper = this.getWrapper(computer, name);
        return wrapper == null ? null : LuaUtil.consArray(wrapper.getType(), wrapper.getAdditionalTypes());
    }

    @LuaFunction
    public final Object @Nullable [] hasTypeRemote(IComputerAccess computer, String name, String type) {
        Object[] objectArray;
        RemotePeripheralWrapper wrapper = this.getWrapper(computer, name);
        if (wrapper == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = wrapper.getType().equals(type) || wrapper.getAdditionalTypes().contains(type);
        }
        return objectArray;
    }

    @LuaFunction
    public final Object @Nullable [] getMethodsRemote(IComputerAccess computer, String name) {
        RemotePeripheralWrapper wrapper = this.getWrapper(computer, name);
        if (wrapper == null) {
            return null;
        }
        return new Object[]{wrapper.getMethodNames()};
    }

    @LuaFunction
    public final MethodResult callRemote(IComputerAccess computer, ILuaContext context, IArguments arguments) throws LuaException {
        String remoteName = arguments.getString(0);
        String methodName = arguments.getString(1);
        RemotePeripheralWrapper wrapper = this.getWrapper(computer, remoteName);
        if (wrapper == null) {
            throw new LuaException("No peripheral: " + remoteName);
        }
        return wrapper.callMethod(context, methodName, arguments.drop(2));
    }

    @LuaFunction
    public final Object @Nullable [] getNameLocal() {
        Object[] objectArray;
        String local = this.localPeripheral.getConnectedName();
        if (local == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = local;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(IComputerAccess computer) {
        ConcurrentMap wrappers;
        super.attach(computer);
        Map<Object, Object> map = this.peripheralWrappers;
        synchronized (map) {
            wrappers = this.peripheralWrappers.computeIfAbsent(computer, k -> new ConcurrentHashMap());
        }
        map = this.modem.getRemotePeripherals();
        synchronized (map) {
            for (Map.Entry<String, IPeripheral> entry : this.modem.getRemotePeripherals().entrySet()) {
                this.attachPeripheralImpl(computer, wrappers, entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(IComputerAccess computer) {
        Map wrappers;
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            wrappers = this.peripheralWrappers.remove(computer);
        }
        if (wrappers != null) {
            for (RemotePeripheralWrapper wrapper : wrappers.values()) {
                wrapper.detach();
            }
            wrappers.clear();
        }
        super.detach(computer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(@Nullable IPeripheral other) {
        if (!(other instanceof WiredModemPeripheral)) return false;
        WiredModemPeripheral otherModem = (WiredModemPeripheral)other;
        if (otherModem.modem != this.modem) return false;
        return true;
    }

    @Override
    public final Object getTarget() {
        return this.target;
    }

    @Override
    public WiredNode getNode() {
        return this.modem.getNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachPeripheral(String name, IPeripheral peripheral) {
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            for (Map.Entry<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> entry : this.peripheralWrappers.entrySet()) {
                this.attachPeripheralImpl(entry.getKey(), entry.getValue(), name, peripheral);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachPeripheral(String name) {
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            for (ConcurrentMap<String, RemotePeripheralWrapper> wrappers : this.peripheralWrappers.values()) {
                RemotePeripheralWrapper wrapper = (RemotePeripheralWrapper)wrappers.remove(name);
                if (wrapper == null) continue;
                wrapper.detach();
            }
        }
    }

    private void attachPeripheralImpl(IComputerAccess computer, ConcurrentMap<String, RemotePeripheralWrapper> peripherals, String periphName, IPeripheral peripheral) {
        if (!peripherals.containsKey(periphName) && !periphName.equals(this.localPeripheral.getConnectedName())) {
            Map<String, PeripheralMethod> methods = ServerContext.get(((class_3218)this.getLevel()).method_8503()).peripheralMethods().getSelfMethods(peripheral);
            RemotePeripheralWrapper wrapper = new RemotePeripheralWrapper(this.modem, peripheral, computer, periphName, methods);
            peripherals.put(periphName, wrapper);
            wrapper.attach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable ConcurrentMap<String, RemotePeripheralWrapper> getWrappers(IComputerAccess computer) {
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            return this.peripheralWrappers.get(computer);
        }
    }

    private @Nullable RemotePeripheralWrapper getWrapper(IComputerAccess computer, String remoteName) {
        ConcurrentMap<String, RemotePeripheralWrapper> wrappers = this.getWrappers(computer);
        return wrappers == null ? null : (RemotePeripheralWrapper)wrappers.get(remoteName);
    }

    private static class RemotePeripheralWrapper
    implements IComputerAccess,
    GuardedLuaContext.Guard {
        private final WiredModemElement element;
        private final IPeripheral peripheral;
        private final IComputerAccess computer;
        private final String name;
        private final String type;
        private final Set<String> additionalTypes;
        private final Map<String, PeripheralMethod> methodMap;
        private volatile boolean attached;
        private final Set<String> mounts = new HashSet<String>();
        private @Nullable GuardedLuaContext contextWrapper;

        RemotePeripheralWrapper(WiredModemElement element, IPeripheral peripheral, IComputerAccess computer, String name, Map<String, PeripheralMethod> methods) {
            this.element = element;
            this.peripheral = peripheral;
            this.computer = computer;
            this.name = name;
            this.type = Objects.requireNonNull(peripheral.getType(), "Peripheral type cannot be null");
            this.additionalTypes = peripheral.getAdditionalTypes();
            this.methodMap = methods;
        }

        public void attach() {
            this.attached = true;
            this.peripheral.attach(this);
            this.computer.queueEvent("peripheral", this.getAttachmentName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach() {
            this.peripheral.detach(this);
            this.computer.queueEvent("peripheral_detach", this.getAttachmentName());
            this.attached = false;
            RemotePeripheralWrapper remotePeripheralWrapper = this;
            synchronized (remotePeripheralWrapper) {
                if (!this.mounts.isEmpty()) {
                    LOG.warn("Peripheral {} called mount but did not call unmount for {}", (Object)this.peripheral, this.mounts);
                }
                for (String mount : this.mounts) {
                    this.computer.unmount(mount);
                }
                this.mounts.clear();
            }
        }

        public String getType() {
            return this.type;
        }

        public Set<String> getAdditionalTypes() {
            return this.additionalTypes;
        }

        public Collection<String> getMethodNames() {
            return this.methodMap.keySet();
        }

        public MethodResult callMethod(ILuaContext context, String methodName, IArguments arguments) throws LuaException {
            PeripheralMethod method = this.methodMap.get(methodName);
            if (method == null) {
                throw new LuaException("No such method " + methodName);
            }
            GuardedLuaContext contextWrapper = this.contextWrapper;
            if (contextWrapper == null || !contextWrapper.wraps(context)) {
                contextWrapper = this.contextWrapper = new GuardedLuaContext(context, this);
            }
            return method.apply(this.peripheral, contextWrapper, this, arguments);
        }

        @Override
        public boolean checkValid() {
            return this.attached;
        }

        @Override
        public synchronized @Nullable String mount(String desiredLocation, Mount mount) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            String mounted = this.computer.mount(desiredLocation, mount, this.name);
            this.mounts.add(mounted);
            return mounted;
        }

        @Override
        public synchronized @Nullable String mount(String desiredLocation, Mount mount, String driveName) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            String mounted = this.computer.mount(desiredLocation, mount, driveName);
            this.mounts.add(mounted);
            return mounted;
        }

        @Override
        public synchronized @Nullable String mountWritable(String desiredLocation, WritableMount mount) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            String mounted = this.computer.mountWritable(desiredLocation, mount, this.name);
            this.mounts.add(mounted);
            return mounted;
        }

        @Override
        public synchronized @Nullable String mountWritable(String desiredLocation, WritableMount mount, String driveName) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            String mounted = this.computer.mountWritable(desiredLocation, mount, driveName);
            this.mounts.add(mounted);
            return mounted;
        }

        @Override
        public synchronized void unmount(@Nullable String location) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            this.computer.unmount(location);
            this.mounts.remove(location);
        }

        @Override
        public int getID() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return this.computer.getID();
        }

        @Override
        public void queueEvent(String event, Object ... arguments) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            this.computer.queueEvent(event, arguments);
        }

        @Override
        public WorkMonitor getMainThreadMonitor() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return this.computer.getMainThreadMonitor();
        }

        @Override
        public String getAttachmentName() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, IPeripheral> getAvailablePeripherals() {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            Map<String, IPeripheral> map = this.element.getRemotePeripherals();
            synchronized (map) {
                return Map.copyOf(this.element.getRemotePeripherals());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable IPeripheral getAvailablePeripheral(String name) {
            if (!this.attached) {
                throw new NotAttachedException();
            }
            Map<String, IPeripheral> map = this.element.getRemotePeripherals();
            synchronized (map) {
                return this.element.getRemotePeripherals().get(name);
            }
        }
    }
}

