/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Expander {
    private static final Logger LOG = LoggerFactory.getLogger(Expander.class);
    private final class_1937 level;
    private final class_2350 down;
    private final class_2350 right;
    private MonitorBlockEntity origin;
    private int width;
    private int height;

    Expander(MonitorBlockEntity origin) {
        this.origin = origin;
        this.width = origin.getWidth();
        this.height = origin.getHeight();
        this.level = Objects.requireNonNull(origin.method_10997(), "level cannot be null");
        this.down = origin.getDown();
        this.right = origin.getRight();
    }

    void expand() {
        int changedCount = 0;
        int changeLimit = Config.monitorWidth * Config.monitorHeight + 1;
        while (this.expandIn(true, false) || this.expandIn(true, true) || this.expandIn(false, false) || this.expandIn(false, true)) {
            if (++changedCount <= changeLimit) continue;
            LOG.error("Monitor has grown too much. This suggests there's an empty monitor in the world.");
            break;
        }
        if (changedCount > 0) {
            this.origin.resize(this.width, this.height);
        }
    }

    private boolean expandIn(boolean useXAxis, boolean isPositive) {
        MonitorBlockEntity otherMonitor;
        class_2338 pos = this.origin.method_11016();
        int height = this.height;
        int width = this.width;
        int otherOffset = isPositive ? (useXAxis ? width : height) : -1;
        class_2338 otherPos = useXAxis ? pos.method_10079(this.right, otherOffset) : pos.method_10079(this.down, otherOffset);
        class_2586 other = this.level.method_8321(otherPos);
        if (!(other instanceof MonitorBlockEntity) || !this.origin.isCompatible(otherMonitor = (MonitorBlockEntity)other)) {
            return false;
        }
        if (useXAxis) {
            if (otherMonitor.getYIndex() != 0 || otherMonitor.getHeight() != height) {
                return false;
            }
            if ((width += otherMonitor.getWidth()) > Config.monitorWidth) {
                return false;
            }
        } else {
            if (otherMonitor.getXIndex() != 0 || otherMonitor.getWidth() != width) {
                return false;
            }
            if ((height += otherMonitor.getHeight()) > Config.monitorHeight) {
                return false;
            }
        }
        if (!isPositive) {
            MonitorBlockEntity originMonitor;
            class_2586 otherOrigin = this.level.method_8321(otherMonitor.toWorldPos(0, 0));
            if (!(otherOrigin instanceof MonitorBlockEntity) || !this.origin.isCompatible(originMonitor = (MonitorBlockEntity)otherOrigin)) {
                return false;
            }
            this.origin = originMonitor;
        }
        this.width = width;
        this.height = height;
        return true;
    }
}

