/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.compat.jei.category;

import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;

public class RecipeCategoryBuilder<T extends class_1860<?>> {
    private final String modid;
    private final Class<? extends T> recipeClass;
    private Predicate<CRecipes> predicate = cRecipes -> true;
    private IDrawable background;
    private IDrawable icon;
    private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
    private final List<Supplier<? extends class_1799>> catalysts = new ArrayList<Supplier<? extends class_1799>>();

    public RecipeCategoryBuilder(String modid, Class<? extends T> recipeClass) {
        this.modid = modid;
        this.recipeClass = recipeClass;
    }

    public RecipeCategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
        this.predicate = predicate;
        return this;
    }

    public RecipeCategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
        this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
        return this;
    }

    public RecipeCategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
        this.recipeListConsumers.add(consumer);
        return this;
    }

    public RecipeCategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
        return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
    }

    public RecipeCategoryBuilder<T> addAllRecipesIf(Predicate<class_1860<?>> pred) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
            if (pred.test((class_1860<?>)recipe)) {
                recipes.add(recipe);
            }
        }));
    }

    public RecipeCategoryBuilder<T> addAllRecipesIf(Predicate<class_1860<?>> pred, Function<class_1860<?>, T> converter) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
            if (pred.test((class_1860<?>)recipe)) {
                recipes.add((class_1860)converter.apply((class_1860<?>)recipe));
            }
        }));
    }

    public <O extends class_1860<?>> RecipeCategoryBuilder<T> addTransformedRecipes(Supplier<class_3956<O>> recipeType, Function<O, T> converter) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((class_1860)converter.apply(recipe)), (class_3956)((class_3956)recipeType.get())));
    }

    public RecipeCategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
        return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
    }

    public RecipeCategoryBuilder<T> addTypedRecipes(Supplier<class_3956<? extends T>> recipeType) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (class_3956)((class_3956)recipeType.get())));
    }

    public RecipeCategoryBuilder<T> addTypedRecipesIf(Supplier<class_3956<? extends T>> recipeType, Predicate<class_1860<?>> pred) {
        return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
            if (pred.test((class_1860<?>)recipe)) {
                recipes.add(recipe);
            }
        }, (class_3956)((class_3956)recipeType.get())));
    }

    public RecipeCategoryBuilder<T> addTypedRecipesExcluding(Supplier<class_3956<? extends T>> recipeType, Supplier<class_3956<? extends T>> excluded) {
        return this.addRecipeListConsumer(recipes -> {
            List excludedRecipes = CreateJEI.getTypedRecipes((class_3956)((class_3956)excluded.get()));
            CreateJEI.consumeTypedRecipes(recipe -> {
                for (class_1860 excludedRecipe : excludedRecipes) {
                    if (!CreateJEI.doInputsMatch((class_1860)recipe, (class_1860)excludedRecipe)) continue;
                    return;
                }
                recipes.add(recipe);
            }, (class_3956)((class_3956)recipeType.get()));
        });
    }

    public RecipeCategoryBuilder<T> removeRecipes(Supplier<class_3956<? extends T>> recipeType) {
        return this.addRecipeListConsumer(recipes -> {
            List excludedRecipes = CreateJEI.getTypedRecipes((class_3956)((class_3956)recipeType.get()));
            recipes.removeIf(recipe -> {
                for (class_1860 excludedRecipe : excludedRecipes) {
                    if (!CreateJEI.doInputsMatch((class_1860)recipe, (class_1860)excludedRecipe)) continue;
                    return true;
                }
                return false;
            });
        });
    }

    public RecipeCategoryBuilder<T> catalystStack(Supplier<class_1799> supplier) {
        this.catalysts.add(supplier);
        return this;
    }

    public RecipeCategoryBuilder<T> catalyst(Supplier<class_1935> supplier) {
        return this.catalystStack(() -> new class_1799((class_1935)((class_1935)supplier.get()).method_8389()));
    }

    public RecipeCategoryBuilder<T> icon(IDrawable icon) {
        this.icon = icon;
        return this;
    }

    public RecipeCategoryBuilder<T> itemIcon(class_1935 item) {
        this.icon((IDrawable)new ItemIcon(() -> new class_1799(item)));
        return this;
    }

    public RecipeCategoryBuilder<T> doubleItemIcon(class_1935 item1, class_1935 item2) {
        this.icon((IDrawable)new DoubleItemIcon(() -> new class_1799(item1), () -> new class_1799(item2)));
        return this;
    }

    public RecipeCategoryBuilder<T> background(IDrawable background) {
        this.background = background;
        return this;
    }

    public RecipeCategoryBuilder<T> emptyBackground(int width, int height) {
        this.background((IDrawable)new EmptyBackground(width, height));
        return this;
    }

    public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
        Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
            ArrayList recipes = new ArrayList();
            for (Consumer consumer : this.recipeListConsumers) {
                consumer.accept(recipes);
            }
            return recipes;
        } : Collections::emptyList;
        class_2960 id = new class_2960(this.modid, name);
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(id, this.recipeClass), (class_2561)EnchantmentIndustry.LANG.fromRL("recipe", id, new Object[0]).component(), this.background, this.icon, recipesSupplier, this.catalysts);
        return factory.create(info);
    }
}

