/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import io.github.fabricators_of_create.porting_lib.models.util.TransformationHelper;
import java.util.Set;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_557;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlock;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlockEntity;

public class BlazeEnchanterRenderer
extends SmartBlockEntityRenderer<BlazeEnchanterBlockEntity> {
    public static final class_4730 BOOK_MATERIAL = new class_4730(class_1059.field_5275, EnchantmentIndustry.genRL("block/blaze_enchanter_book"));
    private static final float PI = (float)Math.PI;
    private final class_557 bookModel;

    public BlazeEnchanterRenderer(class_5614.class_5615 context) {
        super(context);
        this.bookModel = new class_557(context.method_32140(class_5602.field_27685));
    }

    protected void renderSafe(BlazeEnchanterBlockEntity be, float partialTicks, class_4587 ps, class_4597 buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ps, buffer, light, overlay);
        float horizontalAngle = AngleHelper.rad((double)be.headAngle.getValue(partialTicks));
        float animation = be.headAnimation.getValue(partialTicks) * 0.175f;
        ps.method_22903();
        this.renderItem(be, partialTicks, animation, ps, buffer, light, overlay);
        this.renderBlaze(be, horizontalAngle, animation, ps, buffer);
        this.renderBook(be, partialTicks, horizontalAngle, ps, buffer);
        ps.method_22909();
    }

    protected void renderItem(BlazeEnchanterBlockEntity be, float partialTicks, float animation, class_4587 ps, class_4597 buffer, int light, int overlay) {
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        class_2350 insertedFrom = transported.insertedFrom;
        boolean horizontal = insertedFrom.method_10166().method_10179();
        ps.method_22903();
        BlazeEnchanterBlock.HeatLevel heatLevel = (BlazeEnchanterBlock.HeatLevel)((Object)be.method_11010().method_11654(BlazeEnchanterBlock.HEAT_LEVEL));
        boolean active = be.processingTicks > 0 && be.processingTicks < 200;
        float renderTick = AnimationTickHolder.getRenderTime((class_1936)be.method_10997()) + (float)(((Object)((Object)be)).hashCode() % 13) * 16.0f;
        float beltOffset = horizontal ? class_3532.method_16439((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition) : 0.5f;
        float movingProgress = class_3532.method_15374((float)((1.0f - 2.0f * class_3532.method_15379((float)(0.5f - beltOffset))) * (float)Math.PI / 2.0f));
        float verticalOffsetMult = heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.KINDLED) ? 64.0f : 16.0f;
        float verticalOffset = movingProgress * 5.0f / 8.0f + class_3532.method_15374((float)(renderTick / 16.0f % ((float)Math.PI * 2))) / verticalOffsetMult + animation * 0.75f;
        ps.method_46416(0.5f, 0.75f + verticalOffset, 0.5f);
        class_243 offsetVec = class_243.method_24954((class_2382)insertedFrom.method_10153().method_10163()).method_1021((double)(0.5f - beltOffset));
        ps.method_22904(offsetVec.field_1352, 0.0, offsetVec.field_1350);
        if (horizontal) {
            float sideOffset = class_3532.method_16439((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            sideOffset = class_3532.method_16439((float)movingProgress, (float)sideOffset, (float)0.0f);
            boolean alongX = insertedFrom.method_10170().method_10166() == class_2350.class_2351.field_11048;
            ps.method_46416(alongX ? sideOffset : 0.0f, 0.0f, alongX ? 0.0f : -sideOffset);
        }
        float rot = active ? ((float)(200 - be.processingTicks) + partialTicks) / 16.0f % ((float)Math.PI * 2) : renderTick / 16.0f % ((float)Math.PI * 2);
        float rotX = active ? rot + 1.5707964f : 0.0f;
        float rotY = rot + (float)Math.PI + (float)transported.angle * movingProgress;
        float rotZ = active ? rot : 0.0f;
        ps.method_22907(TransformationHelper.quatFromXYZ((float)rotX, (float)rotY, (float)rotZ, (boolean)false));
        ps.method_22905(0.5f, 0.5f, 0.5f);
        class_918 itemRenderer = class_310.method_1551().method_1480();
        itemRenderer.method_23178(transported.stack, class_811.field_4319, light, overlay, ps, buffer, be.method_10997(), 0);
        ps.method_22909();
    }

    protected void renderBlaze(BlazeEnchanterBlockEntity be, float horizontalAngle, float animation, class_4587 ps, class_4597 buffer) {
        class_2680 blockState = be.method_11010();
        BlazeEnchanterBlock.HeatLevel heatLevel = (BlazeEnchanterBlock.HeatLevel)((Object)blockState.method_11654(BlazeEnchanterBlock.HEAT_LEVEL));
        boolean smouldering = heatLevel == BlazeEnchanterBlock.HeatLevel.SMOULDERING;
        boolean active = be.processingTicks > 0 && be.processingTicks < 200;
        float time = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
        float renderTick = time + (float)(((Object)((Object)be)).hashCode() % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeEnchanterBlock.HeatLevel.KINDLED) ? 64.0f : 16.0f;
        float offset = class_3532.method_15374((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = class_3532.method_15374((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        float headY = offset + animation * 0.75f;
        class_4588 solid = buffer.getBuffer(class_1921.method_23577());
        ps.method_22903();
        ps.method_22904(0.0, 0.125, 0.0);
        PartialModel blazeModel = switch (heatLevel) {
            case BlazeEnchanterBlock.HeatLevel.SEETHING -> {
                if (active) {
                    yield AllPartialModels.BLAZE_SUPER_ACTIVE;
                }
                yield AllPartialModels.BLAZE_SUPER;
            }
            case BlazeEnchanterBlock.HeatLevel.KINDLED -> {
                if (active) {
                    yield AllPartialModels.BLAZE_ACTIVE;
                }
                yield AllPartialModels.BLAZE_IDLE;
            }
            default -> AllPartialModels.BLAZE_INERT;
        };
        SuperByteBuffer blazeBuffer = CachedBufferer.partial((PartialModel)blazeModel, (class_2680)blockState);
        blazeBuffer.translate(0.0, (double)headY, 0.0);
        this.draw(blazeBuffer, horizontalAngle, ps, solid);
        if (be.goggles) {
            PartialModel gogglesModel = blazeModel == AllPartialModels.BLAZE_INERT ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES;
            SuperByteBuffer gogglesBuffer = CachedBufferer.partial((PartialModel)gogglesModel, (class_2680)blockState);
            gogglesBuffer.translate(0.0, (double)(headY + 0.5f), 0.0);
            this.draw(gogglesBuffer, horizontalAngle, ps, solid);
        }
        if (!smouldering) {
            PartialModel rodsModel = heatLevel == BlazeEnchanterBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
            PartialModel rodsModel2 = heatLevel == BlazeEnchanterBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
            SuperByteBuffer rodsBuffer = CachedBufferer.partial((PartialModel)rodsModel, (class_2680)blockState);
            rodsBuffer.translate(0.0, (double)(offset1 + animation + 0.125f), 0.0).light(0xF000F0).renderInto(ps, solid);
            SuperByteBuffer rodsBuffer2 = CachedBufferer.partial((PartialModel)rodsModel2, (class_2680)blockState);
            rodsBuffer2.translate(0.0, (double)(offset2 + animation - 0.1875f), 0.0).light(0xF000F0).renderInto(ps, solid);
        }
        ps.method_22909();
    }

    protected void renderBook(BlazeEnchanterBlockEntity be, float partialTicks, float horizontalAngle, class_4587 ps, class_4597 buffer) {
        ps.method_22903();
        ps.method_22904(0.5, 0.25, 0.5);
        float time = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
        ps.method_22904(0.0, (double)0.1f + (double)class_3532.method_15374((float)(time * 0.1f)) * 0.01, 0.0);
        ps.method_22907(class_7833.field_40716.rotation(horizontalAngle + 1.5707964f));
        ps.method_22907(class_7833.field_40718.rotationDegrees(80.0f));
        float flip = class_3532.method_16439((float)partialTicks, (float)be.oFlip, (float)be.flip);
        float page0 = class_3532.method_22450((float)(flip + 0.25f)) * 1.6f - 0.3f;
        float page1 = class_3532.method_22450((float)(flip + 0.75f)) * 1.6f - 0.3f;
        this.bookModel.method_17073(time, class_3532.method_15363((float)page0, (float)0.0f, (float)1.0f), class_3532.method_15363((float)page1, (float)0.0f, (float)1.0f), 1.0f);
        class_4588 vertexconsumer = BOOK_MATERIAL.method_24145(buffer, class_1921::method_23572);
        this.bookModel.method_24184(ps, vertexconsumer, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        ps.method_22909();
    }

    private void draw(SuperByteBuffer buffer, float horizontalAngle, class_4587 ps, class_4588 vc) {
        buffer.rotateCentered(class_2350.field_11036, horizontalAngle).light(0xF000F0).renderInto(ps, vc);
    }

    public static void loadTexture(class_2960 location, Set<class_2960> sprites) {
        if (location.equals((Object)class_1723.field_21668)) {
            sprites.add(BOOK_MATERIAL.method_24147());
        }
    }
}

