/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import java.util.Collection;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7923;

public enum FlowerBlockProxy implements IBlockColorProxy
{
    INSTANCE;

    boolean enabled = true;

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        Integer color;
        if (blockMD.getBlock() instanceof class_2356 && (color = this.getFlowerColor(blockMD, blockPos)) != null) {
            return color;
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, class_2338 blockPos) {
        if (blockMD.getBlock() instanceof class_2356) {
            return blockMD.getTextureColor();
        }
        if (blockMD.getBlock() instanceof class_2362 && JourneymapClient.getInstance().getCoreProperties().mapPlants.get().booleanValue()) {
            try {
                class_2680 blockState = blockMD.getBlockState();
                class_1799 iStack = ((class_2362)blockState.method_26204()).method_9574((class_1922)chunkMD.getWorld(), blockPos, blockState);
                if (iStack != null) {
                    class_2680 contentBlockState = class_2248.method_9503((class_1792)iStack.method_7909()).method_9564();
                    return BlockMD.get(contentBlockState).getTextureColor();
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error checking FlowerPot: " + e, (Object)LogFormatter.toPartialString(e));
                this.enabled = false;
            }
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().getBlockColor(chunkMD, blockMD, blockPos);
    }

    private Integer getFlowerColor(BlockMD blockMd, class_2338 blockPos) {
        class_2680 blockState = blockMd.getBlockState();
        if (blockState.method_26204() instanceof class_2356) {
            class_2248 block = blockState.method_26204();
            return switch (class_7923.field_41175.method_10221((Object)block).method_12832()) {
                case "poppy", "red_tulip" -> 9962502;
                case "blue_orchid" -> 1998518;
                case "allium" -> 8735158;
                case "azure_bluet" -> 10330535;
                case "orange_tulip" -> 10704922;
                case "white_tulip" -> 0xB0B0B0;
                case "pink_tulip" -> 11573936;
                case "oxeye_daisy" -> 0xB3B3B3;
                case "dandelion" -> 11514881;
                case "cornflower" -> 3361970;
                case "lily_of_the_valley" -> 0xFFFFFF;
                case "wither_rose" -> 0x191919;
                default -> this.getUnknownFlowerColor(blockMd, blockPos);
            };
        }
        return null;
    }

    private int getUnknownFlowerColor(BlockMD blockMD, class_2338 blockPos) {
        try {
            Collection<ColoredSprite> sprites = blockMD.getBlockSpritesProxy().getSprites(blockMD, null, null);
            float[] rgba = ColorManager.INSTANCE.getAverageColor(sprites);
            if (rgba != null) {
                return RGB.toInteger(rgba);
            }
            class_2680 blockState = blockMD.getBlockState();
            class_638 level = class_310.method_1551().field_1687;
            return blockState.method_26205((class_1922)level, (class_2338)blockPos).field_16011;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

