/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.element;

import com.simibubi.create.foundation.gui.element.StencilElement;
import javax.annotation.Nonnull;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class CombinedStencilElement
extends StencilElement {
    private StencilElement element1;
    private StencilElement element2;
    private ElementMode mode;

    private CombinedStencilElement() {
    }

    public static CombinedStencilElement of(@Nonnull StencilElement element1, @Nonnull StencilElement element2) {
        return CombinedStencilElement.of(element1, element2, ElementMode.FIRST);
    }

    public static CombinedStencilElement of(@Nonnull StencilElement element1, @Nonnull StencilElement element2, ElementMode mode) {
        CombinedStencilElement e = new CombinedStencilElement();
        e.element1 = element1;
        e.element2 = element2;
        e.mode = mode;
        return e;
    }

    public <T extends CombinedStencilElement> T withFirst(StencilElement element) {
        this.element1 = element;
        return (T)this;
    }

    public <T extends CombinedStencilElement> T withSecond(StencilElement element) {
        this.element2 = element;
        return (T)this;
    }

    public <T extends CombinedStencilElement> T withMode(ElementMode mode) {
        this.mode = mode;
        return (T)this;
    }

    @Override
    protected void renderStencil(class_332 graphics) {
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        this.element1.transform(ms);
        this.element1.withBounds(this.width, this.height);
        this.element1.renderStencil(graphics);
        ms.method_22909();
        ms.method_22903();
        this.element2.transform(ms);
        this.element2.withBounds(this.width, this.height);
        this.element2.renderStencil(graphics);
        ms.method_22909();
    }

    @Override
    protected void renderElement(class_332 graphics) {
        if (this.mode.rendersFirst()) {
            ((StencilElement)this.element1.withBounds(this.width, this.height)).renderElement(graphics);
        }
        if (this.mode.rendersSecond()) {
            ((StencilElement)this.element2.withBounds(this.width, this.height)).renderElement(graphics);
        }
    }

    public static enum ElementMode {
        FIRST,
        SECOND,
        BOTH;


        boolean rendersFirst() {
            return this == FIRST || this == BOTH;
        }

        boolean rendersSecond() {
            return this == SECOND || this == BOTH;
        }
    }
}

