/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class NavigatableSimiScreen
extends AbstractSimiScreen {
    public static final String THINK_BACK = "ponder.think_back";
    protected int depthPointX;
    protected int depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.075f, LerpedFloat.Chaser.LINEAR);
    protected PonderButton backTrack;

    public NavigatableSimiScreen() {
        class_1041 window = class_310.method_1551().method_22683();
        this.depthPointX = window.method_4486() / 2;
        this.depthPointY = window.method_4502() / 2;
    }

    public void method_25419() {
        ScreenOpener.clearStack();
        super.method_25419();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.transition.tickChaser();
        this.arrowAnimation.tickChaser();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.backTrack = null;
        List<class_437> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return;
        }
        if (!(screenHistory.get(0) instanceof NavigatableSimiScreen)) {
            return;
        }
        NavigatableSimiScreen screen = (NavigatableSimiScreen)screenHistory.get(0);
        this.backTrack = (PonderButton)((AbstractSimiWidget)new PonderButton(31, this.field_22790 - 31 - 20).enableFade(0, 5)).withCallback(() -> ScreenOpener.openPreviousScreen(this, Optional.empty()));
        this.method_37063(this.backTrack);
        this.backTrack.fade(1.0f);
        screen.initBackTrackIcon(this.backTrack);
    }

    protected abstract void initBackTrackIcon(PonderButton var1);

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.backTrack == null) {
            return;
        }
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416(0.0f, 0.0f, 500.0f);
        if (this.backTrack.method_25367()) {
            class_5250 translate = Lang.translateDirect(this.backTrackingLangKey(), new Object[0]);
            graphics.method_51439(this.field_22793, (class_2561)translate, 41 - this.field_22793.method_27525((class_5348)translate) / 2, this.field_22790 - 16, Theme.i(Theme.Key.TEXT_DARKER), false);
            if (class_3532.method_15347((float)this.arrowAnimation.getValue(), (float)this.arrowAnimation.getChaseTarget())) {
                this.arrowAnimation.setValue(1.0);
                this.arrowAnimation.setValue(1.0);
            }
        }
        ms.method_22909();
    }

    protected String backTrackingLangKey() {
        return THINK_BACK;
    }

    @Override
    protected void renderWindowBackground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backTrack != null) {
            int x = (int)class_3532.method_16439((float)this.arrowAnimation.getValue(partialTicks), (float)-9.0f, (float)21.0f);
            int maxX = this.backTrack.method_46426() + this.backTrack.method_25368();
            if (x + 30 < this.backTrack.method_46426()) {
                UIRenderHelper.breadcrumbArrow(graphics, x + 30, this.field_22790 - 51, 0, maxX - (x + 30), 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
            }
            UIRenderHelper.breadcrumbArrow(graphics, x, this.field_22790 - 51, 0, 30, 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
            UIRenderHelper.breadcrumbArrow(graphics, x - 30, this.field_22790 - 51, 0, 30, 20, 5, Theme.p(Theme.Key.PONDER_BACK_ARROW));
        }
        if (this.transition.getChaseTarget() == 0.0f || this.transition.settled()) {
            this.method_25420(graphics);
            return;
        }
        this.method_25420(graphics);
        class_4587 ms = graphics.method_51448();
        float transitionValue = this.transition.getValue(partialTicks);
        float scale = 1.0f + 0.5f * transitionValue;
        scale = transitionValue > 0.0f ? 1.0f - 0.5f * (1.0f - transitionValue) : 1.0f + 0.5f * (1.0f + transitionValue);
        ms.method_46416((float)this.depthPointX, (float)this.depthPointY, 0.0f);
        ms.method_22905(scale, scale, 1.0f);
        ms.method_46416((float)(-this.depthPointX), (float)(-this.depthPointY), 0.0f);
    }

    @Override
    public boolean method_25404(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (code == 259) {
            ScreenOpener.openPreviousScreen(this, Optional.empty());
            return true;
        }
        return super.method_25404(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void centerScalingOn(int x, int y) {
        this.depthPointX = x;
        this.depthPointY = y;
    }

    public void centerScalingOnMouse() {
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        this.centerScalingOn((int)mouseX, (int)mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        List<class_437> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty()) {
            return;
        }
        history.add(0, this.field_22787.field_1755);
        int spacing = 20;
        List<String> names = history.stream().map(NavigatableSimiScreen::screenTitle).collect(Collectors.toList());
        int bWidth = names.stream().mapToInt(s -> this.field_22793.method_1727(s) + spacing).sum();
        MutableInt x = new MutableInt(this.field_22789 - bWidth);
        MutableInt y = new MutableInt(this.field_22790 - 18);
        MutableBoolean first = new MutableBoolean(true);
        if (x.getValue() < 25) {
            x.setValue(25);
        }
        class_4587 ms = graphics.method_51448();
        ms.method_22903();
        ms.method_46416(0.0f, 0.0f, 600.0f);
        names.forEach(s -> {
            int sWidth = this.field_22793.method_1727(s);
            UIRenderHelper.breadcrumbArrow(graphics, x.getValue(), y.getValue(), 0, sWidth + spacing, 14, spacing / 2, new Color(-586149872), new Color(0x44101010));
            graphics.method_51433(this.field_22793, s, x.getValue() + 5, y.getValue() + 3, first.getValue() != false ? -1114130 : -2232577, false);
            first.setFalse();
            x.add(sWidth + spacing);
        });
        ms.method_22909();
    }

    private static String screenTitle(class_437 screen) {
        if (screen instanceof NavigatableSimiScreen) {
            return ((NavigatableSimiScreen)screen).getBreadcrumbTitle();
        }
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

