/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.api.features.PlayerRegistryInternal;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface IPlayerRegistry {
    public static IPlayerRegistry getMapping(MinecraftServer server) {
        return PlayerRegistryInternal.get(server);
    }

    @Nullable
    public static IPlayerRegistry getMapping(class_1937 level) {
        if (!level.method_8608() && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return IPlayerRegistry.getMapping(serverLevel.method_8503());
        }
        return null;
    }

    public static int getPlayerId(class_3222 player) {
        return IPlayerRegistry.getMapping(player.method_5682()).getPlayerId(player.method_7334());
    }

    @Nullable
    public static class_3222 getConnected(MinecraftServer server, int playerId) {
        UUID uuid = IPlayerRegistry.getMapping(server).getProfileId(playerId);
        if (uuid == null) {
            return null;
        }
        return server.method_3760().method_14602(uuid);
    }

    default public int getPlayerId(GameProfile gameProfile) {
        UUID profileId = gameProfile.getId();
        if (profileId == null) {
            return -1;
        }
        return this.getPlayerId(profileId);
    }

    public int getPlayerId(UUID var1);

    @Nullable
    public UUID getProfileId(int var1);
}

