/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.Upgrades;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Rects;
import appeng.client.gui.Tooltip;
import appeng.client.gui.style.Blitter;
import appeng.menu.slot.AppEngSlot;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public final class UpgradesPanel
implements ICompositeWidget {
    private static final int SLOT_SIZE = 18;
    private static final int PADDING = 7;
    private static final int MAX_ROWS = 8;
    private static final Blitter BACKGROUND = Blitter.texture("guis/extra_panels.png", 128, 128);
    private static final Blitter INNER_CORNER = BACKGROUND.copy().src(12, 33, 18, 18);
    private final List<class_1735> slots;
    private Point screenOrigin = Point.ZERO;
    private int x;
    private int y;
    private final Supplier<List<class_2561>> tooltipSupplier;

    public UpgradesPanel(List<class_1735> slots) {
        this(slots, Collections::emptyList);
    }

    public UpgradesPanel(List<class_1735> slots, IUpgradeableObject upgradeableObject) {
        this(slots, () -> Upgrades.getTooltipLinesForMachine(upgradeableObject.getUpgrades().getUpgradableItem()));
    }

    public UpgradesPanel(List<class_1735> slots, Supplier<List<class_2561>> tooltipSupplier) {
        this.slots = slots;
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void setPosition(Point position) {
        this.x = position.getX();
        this.y = position.getY();
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    public class_768 getBounds() {
        int slotCount = this.getUpgradeSlotCount();
        int height = 14 + Math.min(8, slotCount) * 18;
        int width = 14 + (slotCount + 8 - 1) / 8 * 18;
        return new class_768(this.x, this.y, width, height);
    }

    @Override
    public void populateScreen(Consumer<class_339> addWidget, class_768 bounds, AEBaseScreen<?> screen) {
        this.screenOrigin = Point.fromTopLeft(bounds);
    }

    @Override
    public void updateBeforeRender() {
        int slotOriginX = this.x + 7;
        int slotOriginY = this.y + 7;
        for (class_1735 slot : this.slots) {
            if (!slot.method_7682()) continue;
            slot.field_7873 = slotOriginX + 1;
            slot.field_7872 = slotOriginY + 1;
            slotOriginY += 18;
        }
    }

    @Override
    public void drawBackgroundLayer(class_332 guiGraphics, class_768 bounds, Point mouse) {
        int slotCount = this.getUpgradeSlotCount();
        if (slotCount <= 0) {
            return;
        }
        int slotOriginX = this.screenOrigin.getX() + this.x + 7;
        int slotOriginY = this.screenOrigin.getY() + this.y + 7;
        for (int i = 0; i < slotCount; ++i) {
            int row = i % 8;
            int col = i / 8;
            int x = slotOriginX + col * 18;
            int y = slotOriginY + row * 18;
            boolean borderLeft = col == 0;
            boolean borderTop = row == 0;
            boolean lastSlot = i + 1 >= slotCount;
            boolean lastRow = row + 1 >= 8;
            boolean borderBottom = lastRow || lastSlot;
            boolean borderRight = i >= slotCount - 8;
            UpgradesPanel.drawSlot(guiGraphics, x, y, borderLeft, borderTop, borderRight, borderBottom);
            if (col <= 0 || !lastSlot || lastRow) continue;
            INNER_CORNER.dest(x, y + 18).blit(guiGraphics);
        }
    }

    @Override
    public void addExclusionZones(List<class_768> exclusionZones, class_768 screenBounds) {
        int remaining;
        int offsetX = screenBounds.method_3321();
        int offsetY = screenBounds.method_3322();
        int slotCount = this.getUpgradeSlotCount();
        int margin = 2;
        int fullCols = slotCount / 8;
        int rightEdge = offsetX + this.x;
        if (fullCols > 0) {
            int fullColWidth = 14 + fullCols * 18;
            exclusionZones.add(Rects.expand(new class_768(rightEdge, offsetY + this.y, fullColWidth, 158), 2));
            rightEdge += fullColWidth;
        }
        if ((remaining = slotCount - fullCols * 8) > 0) {
            exclusionZones.add(Rects.expand(new class_768(rightEdge, offsetY + this.y, 18 + (fullCols > 0 ? 0 : 14), 14 + remaining * 18), 2));
        }
    }

    @Override
    @Nullable
    public Tooltip getTooltip(int mouseX, int mouseY) {
        if (this.getUpgradeSlotCount() == 0) {
            return null;
        }
        List<class_2561> tooltip = this.tooltipSupplier.get();
        if (tooltip.isEmpty()) {
            return null;
        }
        return new Tooltip(tooltip);
    }

    private static void drawSlot(class_332 guiGraphics, int x, int y, boolean borderLeft, boolean borderTop, boolean borderRight, boolean borderBottom) {
        int srcX = 7;
        int srcY = 7;
        int srcWidth = 18;
        int srcHeight = 18;
        if (borderLeft) {
            x -= 7;
            srcX = 0;
            srcWidth += 7;
        }
        if (borderRight) {
            srcWidth += 7;
        }
        if (borderTop) {
            y -= 7;
            srcY = 0;
            srcHeight += 7;
        }
        if (borderBottom) {
            srcHeight += 7;
        }
        BACKGROUND.src(srcX, srcY, srcWidth, srcHeight).dest(x, y).blit(guiGraphics);
    }

    private int getUpgradeSlotCount() {
        int count = 0;
        for (class_1735 slot : this.slots) {
            if (!(slot instanceof AppEngSlot) || !((AppEngSlot)slot).isSlotEnabled()) continue;
            ++count;
        }
        return count;
    }
}

