/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.compiler.LinkParser;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.FlowTagCompiler;
import appeng.client.guidebook.document.flow.LytFlowAnchor;
import appeng.client.guidebook.document.flow.LytFlowLink;
import appeng.client.guidebook.document.flow.LytFlowParent;
import appeng.client.guidebook.document.interaction.TextTooltip;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import java.net.URI;
import java.util.Set;

public class ATagCompiler
extends FlowTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("a");
    }

    @Override
    protected void compile(final PageCompiler compiler, final LytFlowParent parent, final MdxJsxElementFields el) {
        String anchorName = el.getAttributeString("name", "");
        if (!anchorName.isEmpty()) {
            parent.append(new LytFlowAnchor(anchorName));
        }
        String href = el.getAttributeString("href", "");
        String title = el.getAttributeString("title", "");
        if (!href.isEmpty() || !title.isEmpty()) {
            final LytFlowLink link = new LytFlowLink();
            if (!title.isEmpty()) {
                link.setTooltip(new TextTooltip(title));
            }
            if (!href.isEmpty()) {
                LinkParser.parseLink(compiler, href, new LinkParser.Visitor(){

                    @Override
                    public void handlePage(PageAnchor page) {
                        link.setPageLink(page);
                    }

                    @Override
                    public void handleExternal(URI uri) {
                        link.setExternalUrl(uri);
                    }

                    @Override
                    public void handleError(String error) {
                        parent.appendError(compiler, error, el);
                    }
                });
            }
            compiler.compileFlowContext(el.children(), (LytFlowParent)link);
            parent.append(link);
        } else {
            compiler.compileFlowContext(el.children(), parent);
        }
    }
}

