/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.render.RenderContext;
import appeng.client.guidebook.style.TextStyle;

public class LytHeading
extends LytParagraph {
    private int depth = 1;

    public LytHeading() {
        this.setMarginTop(5);
        this.setMarginBottom(5);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        TextStyle style = switch (depth) {
            case 1 -> DefaultStyles.HEADING1;
            case 2 -> DefaultStyles.HEADING2;
            case 3 -> DefaultStyles.HEADING3;
            case 4 -> DefaultStyles.HEADING4;
            case 5 -> DefaultStyles.HEADING5;
            case 6 -> DefaultStyles.HEADING6;
            default -> DefaultStyles.BODY_TEXT;
        };
        this.setStyle(style);
    }

    @Override
    public void render(RenderContext context) {
        super.render(context);
        if (this.depth == 1) {
            LytRect bounds = this.getBounds();
            context.fillRect(bounds.x(), bounds.bottom() - 1, bounds.width(), 1, (ColorValue)SymbolicColor.HEADER1_SEPARATOR);
        } else if (this.depth == 2) {
            LytRect bounds = this.getBounds();
            context.fillRect(bounds.x(), bounds.bottom() - 1, bounds.width(), 1, (ColorValue)SymbolicColor.HEADER2_SEPARATOR);
        }
    }
}

