/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.element;

import appeng.client.guidebook.compiler.IdUtils;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.document.LytErrorSink;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.element.FakeForwardingServerLevel;
import appeng.client.guidebook.scene.element.SceneElementTagCompiler;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_151;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2960;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class ImportStructureElementCompiler
implements SceneElementTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("ImportStructure");
    }

    @Override
    public void compile(GuidebookScene scene, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        class_2487 compoundTag;
        class_2960 absStructureSrc;
        String structureSrc = el.getAttributeString("src", null);
        if (structureSrc == null) {
            errorSink.appendError(compiler, "Missing src attribute", el);
            return;
        }
        try {
            absStructureSrc = IdUtils.resolveLink(structureSrc, compiler.getPageId());
        }
        catch (class_151 e) {
            errorSink.appendError(compiler, "Invalid structure path: " + structureSrc, el);
            return;
        }
        byte[] structureNbtData = compiler.loadAsset(absStructureSrc);
        if (structureNbtData == null) {
            errorSink.appendError(compiler, "Missing structure file", el);
            return;
        }
        try {
            compoundTag = absStructureSrc.method_12832().toLowerCase(Locale.ROOT).endsWith(".snbt") ? class_2512.method_32260((String)new String(structureNbtData, StandardCharsets.UTF_8)) : class_2507.method_10627((DataInput)ByteStreams.newDataInput((byte[])structureNbtData));
        }
        catch (Exception e) {
            errorSink.appendError(compiler, "Couldn't read structure: " + e.getMessage(), el);
            return;
        }
        class_3499 template = new class_3499();
        class_7225.class_7226 blocks = scene.getLevel().method_30349().method_30530(class_7924.field_41254).method_46771();
        template.method_15183((class_7871)blocks, compoundTag);
        class_6575 random = new class_6575(0L);
        class_3492 settings = new class_3492();
        settings.method_15133(true);
        FakeForwardingServerLevel fakeServerLevel = new FakeForwardingServerLevel((class_1936)scene.getLevel());
        if (!template.method_15172((class_5425)fakeServerLevel, class_2338.field_10980, class_2338.field_10980, settings, (class_5819)random, 0)) {
            errorSink.appendError(compiler, "Placed to fail structure", el);
        }
    }
}

