/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.style;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.style.ResolvedTextStyle;
import appeng.client.guidebook.style.TextAlignment;
import appeng.client.guidebook.style.WhiteSpaceMode;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record TextStyle(@Nullable Float fontScale, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable class_2960 font, @Nullable ColorValue color, @Nullable WhiteSpaceMode whiteSpace, @Nullable TextAlignment alignment) {
    public static final TextStyle EMPTY = new TextStyle(null, null, null, null, null, null, null, null, null, null);

    public ResolvedTextStyle mergeWith(ResolvedTextStyle base) {
        float fontScale = this.fontScale != null ? this.fontScale.floatValue() : base.fontScale();
        boolean bold = this.bold != null ? this.bold.booleanValue() : base.bold();
        boolean italic = this.italic != null ? this.italic.booleanValue() : base.italic();
        boolean underlined = this.underlined != null ? this.underlined.booleanValue() : base.underlined();
        boolean strikethrough = this.strikethrough != null ? this.strikethrough.booleanValue() : base.strikethrough();
        boolean obfuscated = this.obfuscated != null ? this.obfuscated.booleanValue() : base.obfuscated();
        class_2960 font = this.font != null ? this.font : base.font();
        ColorValue color = this.color != null ? this.color : base.color();
        WhiteSpaceMode whiteSpace = this.whiteSpace != null ? this.whiteSpace : base.whiteSpace();
        TextAlignment alignment = this.alignment != null ? this.alignment : base.alignment();
        return new ResolvedTextStyle(fontScale, bold, italic, underlined, strikethrough, obfuscated, font, color, whiteSpace, alignment);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.fontScale = this.fontScale;
        builder.bold = this.bold;
        builder.italic = this.italic;
        builder.underlined = this.underlined;
        builder.strikethrough = this.strikethrough;
        builder.obfuscated = this.obfuscated;
        builder.font = this.font;
        builder.color = this.color;
        builder.whiteSpace = this.whiteSpace;
        builder.alignment = this.alignment;
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Float fontScale;
        private Boolean bold;
        private Boolean italic;
        private Boolean underlined;
        private Boolean strikethrough;
        private Boolean obfuscated;
        private class_2960 font;
        private ColorValue color;
        private WhiteSpaceMode whiteSpace;
        private TextAlignment alignment;

        public Builder apply(TextStyle style) {
            if (style.fontScale() != null) {
                this.fontScale = style.fontScale();
            }
            if (style.bold() != null) {
                this.bold = style.bold();
            }
            if (style.italic() != null) {
                this.italic = style.italic();
            }
            if (style.underlined() != null) {
                this.underlined = style.underlined();
            }
            if (style.strikethrough() != null) {
                this.strikethrough = style.strikethrough();
            }
            if (style.obfuscated() != null) {
                this.obfuscated = style.obfuscated();
            }
            if (style.font() != null) {
                this.font = style.font();
            }
            if (style.color() != null) {
                this.color = style.color();
            }
            if (style.whiteSpace() != null) {
                this.whiteSpace = style.whiteSpace();
            }
            if (style.alignment() != null) {
                this.alignment = style.alignment();
            }
            return this;
        }

        public Builder fontScale(Float fontScale) {
            this.fontScale = fontScale;
            return this;
        }

        public Builder bold(Boolean bold) {
            this.bold = bold;
            return this;
        }

        public Builder italic(Boolean italic) {
            this.italic = italic;
            return this;
        }

        public Builder underlined(Boolean underlined) {
            this.underlined = underlined;
            return this;
        }

        public Builder strikethrough(Boolean strikethrough) {
            this.strikethrough = strikethrough;
            return this;
        }

        public Builder obfuscated(Boolean obfuscated) {
            this.obfuscated = obfuscated;
            return this;
        }

        public Builder font(class_2960 font) {
            this.font = font;
            return this;
        }

        public Builder color(ColorValue color) {
            this.color = color;
            return this;
        }

        public Builder whiteSpace(WhiteSpaceMode whiteSpace) {
            this.whiteSpace = whiteSpace;
            return this;
        }

        public Builder alignment(TextAlignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public TextStyle build() {
            return new TextStyle(this.fontScale, this.bold, this.italic, this.underlined, this.strikethrough, this.obfuscated, this.font, this.color, this.whiteSpace, this.alignment);
        }
    }
}

