/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.patternprovider;

import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.IConfigManager;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.settings.TickRates;
import appeng.helpers.InterfaceLogicHost;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.helpers.patternprovider.PatternProviderReturnInventory;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.helpers.patternprovider.PatternProviderTargetCache;
import appeng.helpers.patternprovider.UnlockCraftingEvent;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.PlayerInternalInventory;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternProviderLogic
implements InternalInventoryHost,
ICraftingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternProviderLogic.class);
    public static final String NBT_MEMORY_CARD_PATTERNS = "patterns";
    public static final String NBT_UNLOCK_EVENT = "unlockEvent";
    public static final String NBT_UNLOCK_STACK = "unlockStack";
    public static final String NBT_PRIORITY = "priority";
    public static final String NBT_SEND_LIST = "sendList";
    public static final String NBT_SEND_DIRECTION = "sendDirection";
    public static final String NBT_RETURN_INV = "returnInv";
    private final PatternProviderLogicHost host;
    private final IManagedGridNode mainNode;
    private final IActionSource actionSource;
    private final ConfigManager configManager = new ConfigManager(this::configChanged);
    private int priority;
    private final AppEngInternalInventory patternInventory;
    private final List<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
    private final Set<AEKey> patternInputs = new HashSet<AEKey>();
    private final List<GenericStack> sendList = new ArrayList<GenericStack>();
    private class_2350 sendDirection;
    private final PatternProviderReturnInventory returnInv;
    private final PatternProviderTargetCache[] targetCaches = new PatternProviderTargetCache[6];
    private YesNo redstoneState = YesNo.UNDECIDED;
    @Nullable
    private UnlockCraftingEvent unlockEvent;
    @Nullable
    private GenericStack unlockStack;
    private int roundRobinIndex = 0;

    public @Nullable PatternProviderLogic(IManagedGridNode mainNode, PatternProviderLogicHost host) {
        this(mainNode, host, 9);
    }

    public PatternProviderLogic(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize) {
        this.patternInventory = new AppEngInternalInventory(this, patternInventorySize);
        this.host = host;
        this.mainNode = mainNode.setFlags(GridFlags.REQUIRE_CHANNEL).addService(IGridTickable.class, new Ticker()).addService(ICraftingProvider.class, this);
        this.actionSource = new MachineSource(mainNode::getNode);
        this.configManager.registerSetting(Settings.BLOCKING_MODE, YesNo.NO);
        this.configManager.registerSetting(Settings.PATTERN_ACCESS_TERMINAL, YesNo.YES);
        this.configManager.registerSetting(Settings.LOCK_CRAFTING_MODE, LockCraftingMode.NONE);
        this.returnInv = new PatternProviderReturnInventory(() -> {
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
            this.host.saveChanges();
        });
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.host.saveChanges();
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    public void writeToNBT(class_2487 tag) {
        this.configManager.writeToNBT(tag);
        this.patternInventory.writeToNBT(tag, NBT_MEMORY_CARD_PATTERNS);
        tag.method_10569(NBT_PRIORITY, this.priority);
        if (this.unlockEvent == UnlockCraftingEvent.REDSTONE_POWER) {
            tag.method_10567(NBT_UNLOCK_EVENT, (byte)1);
        } else if (this.unlockEvent == UnlockCraftingEvent.RESULT) {
            if (this.unlockStack != null) {
                tag.method_10567(NBT_UNLOCK_EVENT, (byte)2);
                tag.method_10566(NBT_UNLOCK_STACK, (class_2520)GenericStack.writeTag(this.unlockStack));
            } else {
                LOGGER.error("Saving pattern provider {}, locked waiting for stack, but stack is null!", (Object)this.host);
            }
        } else if (this.unlockEvent == UnlockCraftingEvent.REDSTONE_PULSE) {
            tag.method_10567(NBT_UNLOCK_EVENT, (byte)3);
        }
        class_2499 sendListTag = new class_2499();
        for (GenericStack toSend : this.sendList) {
            sendListTag.add((Object)GenericStack.writeTag(toSend));
        }
        tag.method_10566(NBT_SEND_LIST, (class_2520)sendListTag);
        if (this.sendDirection != null) {
            tag.method_10567(NBT_SEND_DIRECTION, (byte)this.sendDirection.method_10146());
        }
        tag.method_10566(NBT_RETURN_INV, (class_2520)this.returnInv.writeToTag());
    }

    public void readFromNBT(class_2487 tag) {
        this.configManager.readFromNBT(tag);
        this.patternInventory.readFromNBT(tag, NBT_MEMORY_CARD_PATTERNS);
        this.priority = tag.method_10550(NBT_PRIORITY);
        byte unlockEventType = tag.method_10571(NBT_UNLOCK_EVENT);
        switch (unlockEventType) {
            case 0: {
                UnlockCraftingEvent unlockCraftingEvent = null;
                break;
            }
            case 1: {
                UnlockCraftingEvent unlockCraftingEvent = UnlockCraftingEvent.REDSTONE_POWER;
                break;
            }
            case 2: {
                UnlockCraftingEvent unlockCraftingEvent = UnlockCraftingEvent.RESULT;
                break;
            }
            case 3: {
                UnlockCraftingEvent unlockCraftingEvent = UnlockCraftingEvent.REDSTONE_PULSE;
                break;
            }
            default: {
                LOGGER.error("Unknown unlock event type {} in NBT for pattern provider: {}", (Object)unlockEventType, (Object)tag);
                UnlockCraftingEvent unlockCraftingEvent = this.unlockEvent = null;
            }
        }
        if (this.unlockEvent == UnlockCraftingEvent.RESULT) {
            this.unlockStack = GenericStack.readTag(tag.method_10562(NBT_UNLOCK_STACK));
            if (this.unlockStack == null) {
                LOGGER.error("Could not load unlock stack for pattern provider from NBT: {}", (Object)tag);
            }
        } else {
            this.unlockStack = null;
        }
        class_2499 sendListTag = tag.method_10554(NBT_SEND_LIST, 10);
        for (int i = 0; i < sendListTag.size(); ++i) {
            GenericStack stack = GenericStack.readTag(sendListTag.method_10602(i));
            if (stack == null) continue;
            this.addToSendList(stack.what(), stack.amount());
        }
        if (tag.method_10545(NBT_SEND_DIRECTION)) {
            this.sendDirection = class_2350.method_10143((int)tag.method_10571(NBT_SEND_DIRECTION));
        }
        this.returnInv.readFromTag(tag.method_10554(NBT_RETURN_INV, 10));
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public void saveChanges() {
        this.host.saveChanges();
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
        this.updatePatterns();
    }

    @Override
    public boolean isClientSide() {
        class_1937 level = this.host.getBlockEntity().method_10997();
        return level == null || level.method_8608();
    }

    public void updatePatterns() {
        this.patterns.clear();
        this.patternInputs.clear();
        for (class_1799 stack : this.patternInventory) {
            IPatternDetails details = PatternDetailsHelper.decodePattern(stack, this.host.getBlockEntity().method_10997());
            if (details == null) continue;
            this.patterns.add(details);
            for (IPatternDetails.IInput iinput : details.getInputs()) {
                for (GenericStack inputCandidate : iinput.getPossibleInputs()) {
                    this.patternInputs.add(inputCandidate.what().dropSecondary());
                }
            }
        }
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    @Override
    public List<IPatternDetails> getAvailablePatterns() {
        return this.patterns;
    }

    @Override
    public int getPatternPriority() {
        return this.priority;
    }

    private <T> void rearrangeRoundRobin(List<T> list) {
        if (list.isEmpty()) {
            return;
        }
        this.roundRobinIndex %= list.size();
        for (int i = 0; i < this.roundRobinIndex; ++i) {
            list.add(list.get(i));
        }
        list.subList(0, this.roundRobinIndex).clear();
    }

    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.sendList.isEmpty() && this.mainNode.isActive() && this.patterns.contains(patternDetails))) {
            return false;
        }
        class_2586 be = this.host.getBlockEntity();
        class_1937 level = be.method_10997();
        if (this.getCraftingLockedReason() != LockCraftingMode.NONE) {
            return false;
        }
        record PushTarget(class_2350 direction, PatternProviderTarget target) {
        }
        ArrayList<PushTarget> possibleTargets = new ArrayList<PushTarget>();
        for (class_2350 direction : this.getActiveSides()) {
            class_2338 adjPos = be.method_11016().method_10093(direction);
            class_2586 adjBe = level.method_8321(adjPos);
            class_2350 adjBeSide = direction.method_10153();
            ICraftingMachine craftingMachine = ICraftingMachine.of(level, adjPos, adjBeSide, adjBe);
            if (craftingMachine != null && craftingMachine.acceptsPlans()) {
                if (!craftingMachine.pushPattern(patternDetails, inputHolder, adjBeSide)) continue;
                this.onPushPatternSuccess(patternDetails);
                return true;
            }
            PatternProviderTarget adapter = this.findAdapter(direction);
            if (adapter == null) continue;
            possibleTargets.add(new PushTarget(direction, adapter));
        }
        if (!patternDetails.supportsPushInputsToExternalInventory()) {
            return false;
        }
        this.rearrangeRoundRobin(possibleTargets);
        for (int i = 0; i < possibleTargets.size(); ++i) {
            PushTarget target = (PushTarget)possibleTargets.get(i);
            class_2350 direction = target.direction();
            PatternProviderTarget adapter = target.target();
            if (this.isBlocking() && adapter.containsPatternInput(this.patternInputs) || !this.adapterAcceptsAll(adapter, inputHolder)) continue;
            patternDetails.pushInputsToExternalInventory(inputHolder, (what, amount) -> {
                long inserted = adapter.insert(what, amount, Actionable.MODULATE);
                if (inserted < amount) {
                    this.addToSendList(what, amount - inserted);
                }
            });
            this.onPushPatternSuccess(patternDetails);
            this.sendDirection = direction;
            this.sendStacksOut();
            this.roundRobinIndex += i + 1;
            return true;
        }
        return false;
    }

    public void resetCraftingLock() {
        if (this.unlockEvent != null) {
            this.unlockEvent = null;
            this.unlockStack = null;
            this.saveChanges();
        }
    }

    private void onPushPatternSuccess(IPatternDetails pattern) {
        this.resetCraftingLock();
        LockCraftingMode lockMode = this.configManager.getSetting(Settings.LOCK_CRAFTING_MODE);
        switch (lockMode) {
            case LOCK_UNTIL_PULSE: {
                this.unlockEvent = this.getRedstoneState() ? UnlockCraftingEvent.REDSTONE_PULSE : UnlockCraftingEvent.REDSTONE_POWER;
                this.redstoneState = YesNo.UNDECIDED;
                this.saveChanges();
                break;
            }
            case LOCK_UNTIL_RESULT: {
                this.unlockEvent = UnlockCraftingEvent.RESULT;
                this.unlockStack = pattern.getPrimaryOutput();
                this.saveChanges();
            }
        }
    }

    public LockCraftingMode getCraftingLockedReason() {
        LockCraftingMode lockMode = this.configManager.getSetting(Settings.LOCK_CRAFTING_MODE);
        if (lockMode == LockCraftingMode.LOCK_WHILE_LOW && !this.getRedstoneState()) {
            return LockCraftingMode.LOCK_WHILE_LOW;
        }
        if (lockMode == LockCraftingMode.LOCK_WHILE_HIGH && this.getRedstoneState()) {
            return LockCraftingMode.LOCK_WHILE_HIGH;
        }
        if (this.unlockEvent != null) {
            switch (this.unlockEvent) {
                case REDSTONE_POWER: 
                case REDSTONE_PULSE: {
                    return LockCraftingMode.LOCK_UNTIL_PULSE;
                }
                case RESULT: {
                    return LockCraftingMode.LOCK_UNTIL_RESULT;
                }
            }
        }
        return LockCraftingMode.NONE;
    }

    @Nullable
    public GenericStack getUnlockStack() {
        return this.unlockStack;
    }

    private Set<class_2350> getActiveSides() {
        EnumSet<class_2350> sides = this.host.getTargets();
        IGridNode node = this.mainNode.getNode();
        if (node != null) {
            for (Map.Entry<class_2350, IGridConnection> entry : node.getInWorldConnections().entrySet()) {
                IGridNode otherNode = entry.getValue().getOtherSide(node);
                if (!(otherNode.getOwner() instanceof PatternProviderLogicHost) && (!(otherNode.getOwner() instanceof InterfaceLogicHost) || !otherNode.getGrid().equals(this.mainNode.getGrid()))) continue;
                sides.remove(entry.getKey());
            }
        }
        return sides;
    }

    public boolean isBlocking() {
        return this.configManager.getSetting(Settings.BLOCKING_MODE) == YesNo.YES;
    }

    @Nullable
    private PatternProviderTarget findAdapter(class_2350 side) {
        if (this.targetCaches[side.method_10146()] == null) {
            class_2586 thisBe = this.host.getBlockEntity();
            this.targetCaches[side.method_10146()] = new PatternProviderTargetCache((class_3218)thisBe.method_10997(), thisBe.method_11016().method_10093(side), side.method_10153(), this.actionSource);
        }
        return this.targetCaches[side.method_10146()].find();
    }

    private boolean adapterAcceptsAll(PatternProviderTarget target, KeyCounter[] inputHolder) {
        for (KeyCounter inputList : inputHolder) {
            for (Object2LongMap.Entry<AEKey> input : inputList) {
                long inserted = target.insert((AEKey)input.getKey(), input.getLongValue(), Actionable.SIMULATE);
                if (inserted != 0L) continue;
                return false;
            }
        }
        return true;
    }

    private void addToSendList(AEKey what, long amount) {
        if (amount > 0L) {
            this.sendList.add(new GenericStack(what, amount));
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    private boolean sendStacksOut() {
        if (this.sendDirection == null) {
            if (!this.sendList.isEmpty()) {
                throw new IllegalStateException("Invalid pattern provider state, this is a bug.");
            }
            return false;
        }
        PatternProviderTarget adapter = this.findAdapter(this.sendDirection);
        if (adapter == null) {
            return false;
        }
        boolean didSomething = false;
        ListIterator<GenericStack> it = this.sendList.listIterator();
        while (it.hasNext()) {
            long amount;
            GenericStack stack = it.next();
            AEKey what = stack.what();
            long inserted = adapter.insert(what, amount = stack.amount(), Actionable.MODULATE);
            if (inserted >= amount) {
                it.remove();
                didSomething = true;
                continue;
            }
            if (inserted <= 0L) continue;
            it.set(new GenericStack(what, amount - inserted));
            didSomething = true;
        }
        if (this.sendList.isEmpty()) {
            this.sendDirection = null;
        }
        return didSomething;
    }

    @Override
    public boolean isBusy() {
        return !this.sendList.isEmpty();
    }

    private boolean hasWorkToDo() {
        return !this.sendList.isEmpty() || !this.returnInv.isEmpty();
    }

    private boolean doWork() {
        return this.returnInv.injectIntoNetwork(this.mainNode.getGrid().getStorageService().getInventory(), this.actionSource, this::onStackReturnedToNetwork) | this.sendStacksOut();
    }

    public InternalInventory getPatternInv() {
        return this.patternInventory;
    }

    public void onMainNodeStateChanged() {
        if (this.mainNode.isActive()) {
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    public void addDrops(List<class_1799> drops) {
        for (class_1799 class_17992 : this.patternInventory) {
            drops.add(class_17992);
        }
        for (GenericStack genericStack : this.sendList) {
            genericStack.what().addDrops(genericStack.amount(), drops, this.host.getBlockEntity().method_10997(), this.host.getBlockEntity().method_11016());
        }
        this.returnInv.addDrops(drops, this.host.getBlockEntity().method_10997(), this.host.getBlockEntity().method_11016());
    }

    public void clearContent() {
        this.patternInventory.clear();
        this.sendList.clear();
        this.returnInv.clear();
    }

    public PatternProviderReturnInventory getReturnInv() {
        return this.returnInv;
    }

    public void exportSettings(class_2487 output) {
        this.patternInventory.writeToNBT(output, NBT_MEMORY_CARD_PATTERNS);
    }

    public void importSettings(class_2487 input, @Nullable class_1657 player) {
        if (player != null && input.method_10545(NBT_MEMORY_CARD_PATTERNS) && !player.method_37908().field_9236) {
            this.clearPatternInventory(player);
            AppEngInternalInventory desiredPatterns = new AppEngInternalInventory(this.patternInventory.size());
            desiredPatterns.readFromNBT(input, NBT_MEMORY_CARD_PATTERNS);
            class_1661 playerInv = player.method_31548();
            int blankPatternsAvailable = player.method_31549().field_7477 ? Integer.MAX_VALUE : playerInv.method_18861((class_1792)AEItems.BLANK_PATTERN.method_8389());
            int blankPatternsUsed = 0;
            for (int i = 0; i < desiredPatterns.size(); ++i) {
                IPatternDetails pattern = PatternDetailsHelper.decodePattern(desiredPatterns.getStackInSlot(i), this.host.getBlockEntity().method_10997(), true);
                if (pattern == null || blankPatternsAvailable < ++blankPatternsUsed || this.patternInventory.addItems(pattern.getDefinition().toStack()).method_7960()) continue;
                AELog.warn("Failed to add pattern to pattern provider", new Object[0]);
                --blankPatternsUsed;
            }
            if (blankPatternsUsed > 0 && !player.method_31549().field_7477) {
                new PlayerInternalInventory(playerInv).removeItems(blankPatternsUsed, AEItems.BLANK_PATTERN.stack(), null);
            }
            if (blankPatternsUsed > blankPatternsAvailable) {
                player.method_43496((class_2561)PlayerMessages.MissingBlankPatterns.text(blankPatternsUsed - blankPatternsAvailable));
            }
        }
    }

    private void clearPatternInventory(class_1657 player) {
        if (player.method_31549().field_7477) {
            for (int i = 0; i < this.patternInventory.size(); ++i) {
                this.patternInventory.setItemDirect(i, class_1799.field_8037);
            }
            return;
        }
        class_1661 playerInv = player.method_31548();
        int blankPatternCount = 0;
        for (int i = 0; i < this.patternInventory.size(); ++i) {
            class_1799 pattern = this.patternInventory.getStackInSlot(i);
            if (pattern.method_31574((class_1792)AEItems.CRAFTING_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.PROCESSING_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.SMITHING_TABLE_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.STONECUTTING_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.BLANK_PATTERN.method_8389())) {
                blankPatternCount += pattern.method_7947();
            } else {
                playerInv.method_7398(pattern);
            }
            this.patternInventory.setItemDirect(i, class_1799.field_8037);
        }
        if (blankPatternCount > 0) {
            playerInv.method_32338(AEItems.BLANK_PATTERN.stack(blankPatternCount), false);
        }
    }

    private void onStackReturnedToNetwork(GenericStack genericStack) {
        if (this.unlockEvent != UnlockCraftingEvent.RESULT) {
            return;
        }
        if (this.unlockStack == null) {
            LOGGER.error("pattern provider was waiting for RESULT, but no result was set");
            this.unlockEvent = null;
        } else if (this.unlockStack.what().equals(genericStack.what())) {
            long remainingAmount = this.unlockStack.amount() - genericStack.amount();
            if (remainingAmount <= 0L) {
                this.unlockEvent = null;
                this.unlockStack = null;
            } else {
                this.unlockStack = new GenericStack(this.unlockStack.what(), remainingAmount);
            }
        }
    }

    public PatternContainerGroup getTerminalGroup() {
        class_1275 nameable;
        class_2586 host = this.host.getBlockEntity();
        class_1937 hostLevel = host.method_10997();
        PatternProviderLogicHost patternProviderLogicHost = this.host;
        if (patternProviderLogicHost instanceof class_1275 && (nameable = (class_1275)patternProviderLogicHost).method_16914()) {
            class_2561 name = nameable.method_5797();
            return new PatternContainerGroup(this.host.getTerminalIcon(), name, List.of());
        }
        Set<class_2350> sides = this.getActiveSides();
        LinkedHashSet<PatternContainerGroup> groups = new LinkedHashSet<PatternContainerGroup>(sides.size());
        for (class_2350 class_23502 : sides) {
            class_2338 sidePos = host.method_11016().method_10093(class_23502);
            PatternContainerGroup group = PatternContainerGroup.fromMachine(hostLevel, sidePos, class_23502.method_10153());
            if (group == null) continue;
            groups.add(group);
        }
        if (groups.size() == 1) {
            return (PatternContainerGroup)groups.iterator().next();
        }
        List<class_2561> tooltip = List.of();
        if (groups.size() > 1) {
            tooltip = new ArrayList();
            tooltip.add((class_2561)GuiText.AdjacentToDifferentMachines.text().method_27692(class_124.field_1067));
            for (PatternContainerGroup group : groups) {
                tooltip.add(group.name());
                for (class_2561 line : group.tooltip()) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852(line));
                }
            }
        }
        AEItemKey aEItemKey = this.host.getTerminalIcon();
        return new PatternContainerGroup(aEItemKey, aEItemKey.getDisplayName(), tooltip);
    }

    public long getSortValue() {
        class_2586 te = this.host.getBlockEntity();
        return te.method_11016().method_10260() << 24 ^ te.method_11016().method_10263() << 8 ^ te.method_11016().method_10264();
    }

    @Nullable
    public IGrid getGrid() {
        return this.mainNode.getGrid();
    }

    public void updateRedstoneState() {
        if (this.unlockEvent == UnlockCraftingEvent.REDSTONE_POWER && this.getRedstoneState()) {
            this.unlockEvent = null;
            this.saveChanges();
        } else if (this.unlockEvent == UnlockCraftingEvent.REDSTONE_PULSE && !this.getRedstoneState()) {
            this.unlockEvent = UnlockCraftingEvent.REDSTONE_POWER;
            this.redstoneState = YesNo.UNDECIDED;
            this.saveChanges();
        } else {
            this.redstoneState = YesNo.UNDECIDED;
        }
    }

    private void configChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.LOCK_CRAFTING_MODE) {
            this.resetCraftingLock();
        } else {
            this.saveChanges();
        }
    }

    private boolean getRedstoneState() {
        if (this.redstoneState == YesNo.UNDECIDED) {
            class_2586 be = this.host.getBlockEntity();
            this.redstoneState = be.method_10997().method_49803(be.method_11016()) ? YesNo.YES : YesNo.NO;
        }
        return this.redstoneState == YesNo.YES;
    }

    private class Ticker
    implements IGridTickable {
        private Ticker() {
        }

        @Override
        public TickingRequest getTickingRequest(IGridNode node) {
            return new TickingRequest(TickRates.Interface, !PatternProviderLogic.this.hasWorkToDo(), true);
        }

        @Override
        public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
            if (!PatternProviderLogic.this.mainNode.isActive()) {
                return TickRateModulation.SLEEP;
            }
            boolean couldDoWork = PatternProviderLogic.this.doWork();
            return PatternProviderLogic.this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
        }
    }
}

