/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.parts;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.IconProvider;
import appeng.api.integrations.igtooltip.providers.NameProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.integration.modules.igtooltip.parts.PartTooltipProviders;
import appeng.util.Platform;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class PartHostTooltips {
    private PartHostTooltips() {
    }

    @Nullable
    public static class_2561 getName(class_2586 object, TooltipContext context) {
        return PartHostTooltips.getName((IPartHost)object, context);
    }

    @Nullable
    public static class_2561 getName(IPartHost object, TooltipContext context) {
        SelectedPart selected = PartHostTooltips.getPart(object, context.hitLocation());
        if (selected.facade != null) {
            return selected.facade.getItemStack().method_7964();
        }
        if (selected.part != null) {
            for (NameProvider<IPart> provider : PartTooltipProviders.getProviders(selected.part).nameProviders()) {
                class_2561 name = provider.getName(selected.part, context);
                if (name == null) continue;
                return name;
            }
            return selected.part.getPartItem().method_8389().method_7848();
        }
        return null;
    }

    @Nullable
    public static String getModName(class_2586 blockEntity, TooltipContext context) {
        return PartHostTooltips.getModName((IPartHost)blockEntity, context);
    }

    @Nullable
    public static String getModName(IPartHost object, TooltipContext context) {
        class_1792 item;
        SelectedPart selected = PartHostTooltips.getPart(object, context.hitLocation());
        if (selected.facade != null) {
            item = selected.facade.getItemStack().method_7909();
        } else if (selected.part != null) {
            item = selected.part.getPartItem().method_8389();
        } else {
            return null;
        }
        return Platform.getModName(class_7923.field_41178.method_10221((Object)item).method_12836());
    }

    @Nullable
    public static class_1799 getIcon(class_2586 object, TooltipContext context) {
        return PartHostTooltips.getIcon((IPartHost)object, context);
    }

    @Nullable
    public static class_1799 getIcon(IPartHost object, TooltipContext context) {
        SelectedPart selected = PartHostTooltips.getPart(object, context.hitLocation());
        if (selected.facade != null) {
            return selected.facade.getItemStack();
        }
        if (selected.part != null) {
            for (IconProvider<IPart> provider : PartTooltipProviders.getProviders(selected.part).iconProviders()) {
                class_1799 icon = provider.getIcon(selected.part, context);
                if (icon == null) continue;
                return icon;
            }
            return new class_1799(selected.part.getPartItem());
        }
        return null;
    }

    public static void buildTooltip(class_2586 object, TooltipContext context, TooltipBuilder tooltip) {
        PartHostTooltips.buildTooltip((IPartHost)object, context, tooltip);
    }

    public static void buildTooltip(IPartHost object, TooltipContext context, TooltipBuilder tooltip) {
        SelectedPart selected = PartHostTooltips.getPart(object, context.hitLocation());
        if (selected.part != null) {
            class_2487 partTag = context.serverData().method_10562(PartHostTooltips.getPartDataName(selected.side));
            PartHostTooltips.buildPartTooltip(selected.part, partTag, context, tooltip);
        }
    }

    private static <T extends IPart> void buildPartTooltip(T part, class_2487 partTag, TooltipContext blockContext, TooltipBuilder tooltip) {
        TooltipContext partContext = new TooltipContext(partTag, blockContext.hitLocation(), blockContext.player());
        for (BodyProvider<T> provider : PartTooltipProviders.getProviders(part).bodyProviders()) {
            provider.buildTooltip(part, partContext, tooltip);
        }
    }

    public static void provideServerData(class_1657 player, class_2586 object, class_2487 serverData) {
        PartHostTooltips.provideServerData(player, (IPartHost)object, serverData);
    }

    public static void provideServerData(class_1657 player, IPartHost object, class_2487 serverData) {
        class_2487 partTag = new class_2487();
        for (class_2350 location : Platform.DIRECTIONS_WITH_NULL) {
            IPart part = object.getPart(location);
            if (part == null) continue;
            for (ServerDataProvider<IPart> provider : PartTooltipProviders.getProviders(part).serverDataProviders()) {
                provider.provideServerData(player, part, partTag);
            }
            if (partTag.method_33133()) continue;
            serverData.method_10566(PartHostTooltips.getPartDataName(location), (class_2520)partTag);
            partTag = new class_2487();
        }
    }

    private static String getPartDataName(@Nullable class_2350 location) {
        return "cableBusPart" + (location == null ? "center" : location.name());
    }

    private static SelectedPart getPart(IPartHost partHost, class_243 hitLocation) {
        return partHost.selectPartWorld(hitLocation);
    }
}

