/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.leashable.common.entities;

import com.blackgear.vanillabackport.common.api.leash.InterpolationHandler;
import com.blackgear.vanillabackport.common.api.leash.Leashable;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1532;
import net.minecraft.class_1690;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2740;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1690.class})
public abstract class BoatMixin
extends class_1297
implements Leashable {
    @Unique
    private final InterpolationHandler interpolation = new InterpolationHandler(this, 3);
    @Unique
    @Nullable
    class_1297 leashHolder;
    @Unique
    private int delayedLeashHolderId;
    @Unique
    @Nullable
    class_2487 leashInfoTag;
    @Unique
    private double angularMomentum;

    public BoatMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public double angularMomentum() {
        return this.angularMomentum;
    }

    @Override
    public void setAngularMomentum(double angularMomentum) {
        this.angularMomentum = angularMomentum;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void vb$onTick(CallbackInfo ci) {
        if (!this.method_37908().field_9236) {
            this.vb$tickLeash();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void vb$addAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        if (this.leashHolder != null) {
            class_2487 data = new class_2487();
            if (this.leashHolder instanceof class_1309) {
                UUID uuid = this.leashHolder.method_5667();
                data.method_25927("UUID", uuid);
            } else if (this.leashHolder instanceof class_1530) {
                class_2338 pos = ((class_1530)this.leashHolder).method_6896();
                data.method_10569("X", pos.method_10263());
                data.method_10569("Y", pos.method_10264());
                data.method_10569("Z", pos.method_10260());
            }
            tag.method_10566("Leash", (class_2520)data);
        } else if (this.leashInfoTag != null) {
            tag.method_10566("Leash", (class_2520)this.leashInfoTag.method_10553());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void vb$readAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10573("Leash", 10)) {
            this.leashInfoTag = tag.method_10562("Leash");
        }
    }

    @Unique
    private void vb$tickLeash() {
        if (this.leashInfoTag != null) {
            this.vb$restoreLeashFromSave();
        }
        if (!(this.leashHolder == null || this.method_5805() && this.leashHolder.method_5805())) {
            this.dropLeash(true, true);
        }
        Leashable.onTickLeash(this);
    }

    @Override
    public void dropLeash(boolean broadcast, boolean dropItem) {
        if (this.leashHolder != null) {
            class_1937 class_19372;
            this.leashHolder = null;
            this.leashInfoTag = null;
            if (!this.method_37908().field_9236 && dropItem) {
                this.method_5706((class_1935)class_1802.field_8719);
            }
            if (!this.method_37908().field_9236 && broadcast && (class_19372 = this.method_37908()) instanceof class_3218) {
                class_3218 server = (class_3218)class_19372;
                server.method_14178().method_18754((class_1297)this, (class_2596)new class_2740((class_1297)this, null));
            }
        }
    }

    protected class_243 method_29919() {
        return new class_243(0.0, (double)(0.88f * this.method_17682()), (double)(0.64f * this.method_17681()));
    }

    @Override
    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (!this.method_37908().field_9236 && reason.method_31486() && this.isLeashed()) {
            this.dropLeash(true, true);
        }
        super.method_5650(reason);
    }

    @Override
    @Nullable
    public class_1297 getLeashHolder() {
        if (this.leashHolder == null && this.delayedLeashHolderId != 0 && this.method_37908().field_9236) {
            this.leashHolder = this.method_37908().method_8469(this.delayedLeashHolderId);
        }
        return this.leashHolder;
    }

    @Override
    public void setLeashedTo(class_1297 entity, boolean sendAttachPacket) {
        class_1937 class_19372;
        this.leashHolder = entity;
        this.leashInfoTag = null;
        if (!this.method_37908().field_9236 && sendAttachPacket && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            server.method_14178().method_18754((class_1297)this, (class_2596)new class_2740((class_1297)this, this.leashHolder));
        }
        if (this.method_5765()) {
            this.method_5848();
        }
    }

    @Override
    public void setBoatDelayedLeashHolderId(int leashHolderId) {
        this.delayedLeashHolderId = leashHolderId;
        this.dropLeash(false, false);
    }

    @Unique
    private void vb$restoreLeashFromSave() {
        class_1937 class_19372;
        if (this.leashInfoTag != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (this.leashInfoTag.method_25928("UUID")) {
                UUID uuid = this.leashInfoTag.method_25926("UUID");
                class_1297 entity = server.method_14190(uuid);
                if (entity != null) {
                    this.setLeashedTo(entity, true);
                    return;
                }
            } else if (this.leashInfoTag.method_10573("X", 99) && this.leashInfoTag.method_10573("Y", 99) && this.leashInfoTag.method_10573("Z", 99)) {
                class_2338 pos = class_2512.method_10691((class_2487)this.leashInfoTag);
                this.setLeashedTo((class_1297)class_1532.method_6932((class_1937)this.method_37908(), (class_2338)pos), true);
                return;
            }
            if (this.field_6012 > 100) {
                this.method_5706((class_1935)class_1802.field_8719);
                this.leashInfoTag = null;
            }
        }
    }

    protected void method_30076() {
        super.method_30076();
        this.dropLeash(true, false);
    }

    @Inject(method={"lerpTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$lerpTo(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport, CallbackInfo ci) {
        ci.cancel();
        this.interpolation.interpolateTo(new class_243(x, y, z), yRot, xRot);
    }

    @Inject(method={"tickLerp"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$tickLerp(CallbackInfo ci) {
        ci.cancel();
        if (this.method_5787()) {
            this.interpolation.cancel();
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        this.interpolation.interpolate();
    }
}

