/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.config.input.KeyBind;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class WailaConfig
implements IWailaConfig {
    public static final Supplier<IJsonConfig.Commenter> COMMENTER = () -> {
        WailaConfig defaultValue = new WailaConfig();
        class_2477 language = class_2477.method_10517();
        return path -> {
            if (path.isEmpty()) {
                return null;
            }
            AnnotatedElement element = null;
            Object value = defaultValue;
            Class parentCls = WailaConfig.class;
            for (String part : path) {
                try {
                    Field field = parentCls.getDeclaredField(part);
                    field.setAccessible(true);
                    value = field.get(value);
                    element = field;
                    parentCls = field.getType();
                }
                catch (NoSuchFieldException field) {
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (element == null) {
                return null;
            }
            if (value instanceof Nested) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            T tlKey = element.getAnnotation(T.class);
            if (tlKey != null) {
                sb.append(language.method_48307(tlKey.value()));
                String descKey = tlKey.value() + "_desc";
                if (language.method_4678(descKey)) {
                    sb.append('\n').append(language.method_48307(descKey));
                }
                sb.append('\n');
            }
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                sb.append(language.method_48307("json5.waila.config.default_value").formatted(e.name()));
                StringBuilder valuesSb = new StringBuilder();
                Enum[] enums = (Enum[])e.getDeclaringClass().getEnumConstants();
                valuesSb.append(enums[0].name());
                for (int i = 1; i < enums.length; ++i) {
                    Enum anEnum = enums[i];
                    valuesSb.append(", ").append(anEnum.name());
                }
                sb.append("\n").append(language.method_48307("json5.waila.config.available_values").formatted(valuesSb));
            } else if (!(value instanceof Map) && !(value instanceof Collection)) {
                sb.append(language.method_48307("json5.waila.config.default_value").formatted(value));
            }
            return sb.toString();
        };
    };
    private final General general = new General();
    private final Overlay overlay = new Overlay();
    @IJsonConfig.Comment(value="Text formatters")
    private final Formatter formatter = new Formatter();
    private final KeyBinds keyBinds = new KeyBinds();
    @IJsonConfig.Comment(value="Internal value, DO NOT TOUCH!")
    private int configVersion = 0;

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    @Override
    public General getGeneral() {
        return this.general;
    }

    @Override
    public Overlay getOverlay() {
        return this.overlay;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    public KeyBinds getKeyBinds() {
        return this.keyBinds;
    }

    public static class General
    implements IWailaConfig.General,
    Nested {
        @T(value="config.waila.vanilla_options")
        private boolean vanillaOptions = false;
        @T(value="config.waila.display_tooltip")
        private boolean displayTooltip = true;
        @T(value="config.waila.sneaky_details")
        private boolean shiftForDetails = false;
        @T(value="config.waila.hide_sneak_text")
        private boolean hideShiftText = false;
        @T(value="config.waila.display_mode")
        private IWailaConfig.General.DisplayMode displayMode = IWailaConfig.General.DisplayMode.TOGGLE;
        @T(value="config.waila.hide_from_players")
        private boolean hideFromPlayerList = true;
        @T(value="config.waila.hide_from_debug")
        private boolean hideFromDebug = true;
        @T(value="config.waila.tts")
        private boolean enableTextToSpeech = false;
        @T(value="config.waila.rate_limit")
        private int rateLimit = 250;

        public boolean vanillaOptions() {
            return this.vanillaOptions;
        }

        public void setVanillaOptions(boolean vanillaOptions) {
            this.vanillaOptions = vanillaOptions;
        }

        @Override
        public boolean isDisplayTooltip() {
            return this.displayTooltip;
        }

        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean isShiftForDetails() {
            return this.shiftForDetails;
        }

        public void setShiftForDetails(boolean shiftForDetails) {
            this.shiftForDetails = shiftForDetails;
        }

        @Override
        public boolean isHideShiftText() {
            return this.hideShiftText;
        }

        public void setHideShiftText(boolean hideShiftText) {
            this.hideShiftText = hideShiftText;
        }

        @Override
        public IWailaConfig.General.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public void setDisplayMode(IWailaConfig.General.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean isHideFromPlayerList() {
            return this.hideFromPlayerList;
        }

        public void setHideFromPlayerList(boolean hideFromPlayerList) {
            this.hideFromPlayerList = hideFromPlayerList;
        }

        @Override
        public boolean isHideFromDebug() {
            return this.hideFromDebug;
        }

        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        @Override
        public boolean isEnableTextToSpeech() {
            return this.enableTextToSpeech;
        }

        public void setEnableTextToSpeech(boolean enableTextToSpeech) {
            this.enableTextToSpeech = enableTextToSpeech;
        }

        @Override
        public int getRateLimit() {
            this.rateLimit = Math.max(this.rateLimit, 250);
            return this.rateLimit;
        }

        public void setRateLimit(int rateLimit) {
            this.rateLimit = rateLimit;
        }
    }

    public static class Overlay
    implements IWailaConfig.Overlay,
    Nested {
        private final Position position = new Position();
        private final Color color = new Color();
        @T(value="config.waila.overlay_scale")
        private float scale = 1.0f;
        @T(value="config.waila.overlay_fps")
        private int fps = 30;

        @Override
        public Position getPosition() {
            return this.position;
        }

        @Override
        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public int getFps() {
            return this.fps;
        }

        public void setFps(int fps) {
            this.fps = fps;
        }

        public static class Position
        implements IWailaConfig.Overlay.Position,
        Nested {
            private final Align align = new Align();
            private final Align anchor = new Align();
            @T(value="config.waila.overlay_offset")
            private int x = 0;
            private int y = 0;
            @T(value="config.waila.boss_bars_overlap")
            private boolean bossBarsOverlap = false;

            @Override
            public int getX() {
                return this.x;
            }

            public void setX(int x) {
                this.x = x;
            }

            @Override
            public int getY() {
                return this.y;
            }

            public void setY(int y) {
                this.y = y;
            }

            @Override
            public Align getAlign() {
                return this.align;
            }

            @Override
            public Align getAnchor() {
                return this.anchor;
            }

            @Override
            public boolean isBossBarsOverlap() {
                return this.bossBarsOverlap;
            }

            public void setBossBarsOverlap(boolean bossBarsOverlap) {
                this.bossBarsOverlap = bossBarsOverlap;
            }

            public static class Align
            implements IWailaConfig.Overlay.Position.Align,
            Nested {
                IWailaConfig.Overlay.Position.Align.X x = IWailaConfig.Overlay.Position.Align.X.CENTER;
                IWailaConfig.Overlay.Position.Align.Y y = IWailaConfig.Overlay.Position.Align.Y.TOP;

                @Override
                public IWailaConfig.Overlay.Position.Align.X getX() {
                    return this.x;
                }

                public void setX(IWailaConfig.Overlay.Position.Align.X x) {
                    this.x = x;
                }

                @Override
                public IWailaConfig.Overlay.Position.Align.Y getY() {
                    return this.y;
                }

                public void setY(IWailaConfig.Overlay.Position.Align.Y y) {
                    this.y = y;
                }
            }
        }

        public static class Color
        implements IWailaConfig.Overlay.Color,
        Nested {
            private static final class_2960 DEFAULT = Waila.id("vanilla");
            @T(value="config.waila.overlay_background_alpha")
            private int backgroundAlpha = 204;
            @T(value="config.waila.overlay_theme")
            private class_2960 activeTheme = DEFAULT;
            @IJsonConfig.Comment(value="Custom Themes")
            private final Map<class_2960, ThemeDefinition<?>> themes = new HashMap();

            private ThemeDefinition<?> getThemeDef() {
                Map<class_2960, ThemeDefinition<?>> allTheme = ThemeDefinition.getAll();
                if (!allTheme.containsKey(this.activeTheme)) {
                    this.activeTheme = DEFAULT;
                    WailaClient.CONFIG.save();
                }
                return allTheme.get(this.activeTheme);
            }

            @Override
            public int getBackgroundAlpha() {
                return this.backgroundAlpha;
            }

            public void setBackgroundAlpha(int backgroundAlpha) {
                this.backgroundAlpha = backgroundAlpha;
            }

            @Override
            public ITheme getTheme() {
                return this.getThemeDef().getInitializedInstance();
            }

            public Map<class_2960, ThemeDefinition<?>> getCustomThemes() {
                return this.themes;
            }

            public class_2960 getActiveTheme() {
                return this.activeTheme;
            }

            public void applyTheme(class_2960 id) {
                Map<class_2960, ThemeDefinition<?>> allTheme = ThemeDefinition.getAll();
                this.activeTheme = allTheme.containsKey(id) ? id : this.activeTheme;
            }

            public static class Adapter
            implements JsonSerializer<Color>,
            JsonDeserializer<Color> {
                public Color deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject json = element.getAsJsonObject();
                    Color color = new Color();
                    color.backgroundAlpha = json.has("backgroundAlpha") ? json.getAsJsonPrimitive("backgroundAlpha").getAsInt() : 204;
                    color.activeTheme = new class_2960(json.getAsJsonPrimitive("activeTheme").getAsString());
                    json.getAsJsonArray("themes").forEach(e -> {
                        ThemeDefinition themeDef = (ThemeDefinition)context.deserialize(e, ThemeDefinition.class);
                        color.themes.put(themeDef.id, themeDef);
                    });
                    return color;
                }

                public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject json = new JsonObject();
                    json.addProperty("backgroundAlpha", (Number)src.backgroundAlpha);
                    json.add("themes", context.serialize(src.themes.values()));
                    json.addProperty("activeTheme", src.activeTheme.toString());
                    return json;
                }
            }
        }
    }

    public static class Formatter
    implements IWailaConfig.Formatter,
    Nested {
        private String modName = "\u00a79\u00a7o%s";
        private String blockName = "\u00a7f%s";
        private String fluidName = "\u00a7f%s";
        private String entityName = "\u00a7f%s";
        private String registryName = "\u00a78%s";
        private final Map<String, class_2583> styles = new ConcurrentHashMap<String, class_2583>();

        public String getModName() {
            return this.modName;
        }

        public void setModName(String modName) {
            this.styles.remove(this.modName);
            this.modName = modName;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public void setBlockName(String blockName) {
            this.styles.remove(this.blockName);
            this.blockName = blockName;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public void setFluidName(String fluidName) {
            this.styles.remove(this.fluidName);
            this.fluidName = fluidName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.styles.remove(this.entityName);
            this.entityName = entityName;
        }

        public String getRegistryName() {
            return this.registryName;
        }

        public void setRegistryName(String registryName) {
            this.styles.remove(this.registryName);
            this.registryName = registryName;
        }

        private class_2561 formatted(String format, Object object) {
            if (object instanceof class_2561) {
                class_2561 component = (class_2561)object;
                class_2583 style = this.styles.computeIfAbsent(format, f -> {
                    class_2583[] ret = new class_2583[]{class_2583.field_24360};
                    class_2561.method_43470((String)String.format(f, "B")).method_30937().accept((i, s, j) -> {
                        ret[0] = s;
                        return true;
                    });
                    return ret[0];
                });
                return component.method_27661().method_27696(style);
            }
            return class_2561.method_43470((String)String.format(format, object));
        }

        @Override
        public class_2561 modName(Object modName) {
            return this.formatted(this.modName, modName);
        }

        @Override
        public class_2561 blockName(Object blockName) {
            return this.formatted(this.blockName, blockName);
        }

        @Override
        public class_2561 fluidName(Object fluidName) {
            return this.formatted(this.fluidName, fluidName);
        }

        @Override
        public class_2561 entityName(Object entityName) {
            return this.formatted(this.entityName, entityName);
        }

        @Override
        public class_2561 registryName(Object registryName) {
            return this.formatted(this.registryName, registryName);
        }
    }

    public static class KeyBinds
    implements Nested {
        @T(value="key.waila.config")
        private KeyBind openConfig = KeyBind.UNKNOWN;
        @T(value="key.waila.show_overlay")
        private KeyBind showOverlay = KeyBind.UNKNOWN;
        @T(value="key.waila.toggle_liquid")
        private KeyBind toggleLiquid = KeyBind.UNKNOWN;
        @T(value="key.waila.show_recipe_input")
        private KeyBind showRecipeInput = KeyBind.UNKNOWN;
        @T(value="key.waila.show_recipe_output")
        private KeyBind showRecipeOutput = KeyBind.UNKNOWN;

        public KeyBind getOpenConfig() {
            return this.openConfig;
        }

        public void setOpenConfig(KeyBind openConfig) {
            this.openConfig = openConfig;
        }

        public KeyBind getShowOverlay() {
            return this.showOverlay;
        }

        public void setShowOverlay(KeyBind showOverlay) {
            this.showOverlay = showOverlay;
        }

        public KeyBind getToggleLiquid() {
            return this.toggleLiquid;
        }

        public void setToggleLiquid(KeyBind toggleLiquid) {
            this.toggleLiquid = toggleLiquid;
        }

        public KeyBind getShowRecipeInput() {
            return this.showRecipeInput;
        }

        public void setShowRecipeInput(KeyBind showRecipeInput) {
            this.showRecipeInput = showRecipeInput;
        }

        public KeyBind getShowRecipeOutput() {
            return this.showRecipeOutput;
        }

        public void setShowRecipeOutput(KeyBind showRecipeOutput) {
            this.showRecipeOutput = showRecipeOutput;
        }
    }

    static interface Nested {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface T {
        public String value();
    }
}

