/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.boiler.fabric;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.CustomLoaderBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public class ObjModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private class_2960 modelLocation;
    private Boolean automaticCulling;
    private Boolean shadeQuads;
    private Boolean flipV;
    private Boolean emissiveAmbient;
    private class_2960 mtlOverride;
    private static final class_2960 FORGE_OBJ = new class_2960("forge", "obj");
    private static final class_2960 PORTING_LIB_LOADER = new class_2960("porting_lib", "loader");
    private static final class_2960 PORTING_LIB_OBJ = new class_2960("porting_lib", "obj");

    public static <T extends ModelBuilder<T>> ObjModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new ObjModelBuilder<T>(parent, existingFileHelper);
    }

    protected ObjModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(FORGE_OBJ, parent, existingFileHelper);
    }

    public ObjModelBuilder<T> modelLocation(class_2960 modelLocation) {
        Preconditions.checkNotNull((Object)modelLocation, (Object)"modelLocation must not be null");
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(modelLocation, class_3264.field_14188), (String)"OBJ Model %s does not exist in any known resource pack", (Object)modelLocation);
        this.modelLocation = modelLocation;
        return this;
    }

    public ObjModelBuilder<T> automaticCulling(boolean automaticCulling) {
        this.automaticCulling = automaticCulling;
        return this;
    }

    public ObjModelBuilder<T> shadeQuads(boolean shadeQuads) {
        this.shadeQuads = shadeQuads;
        return this;
    }

    public ObjModelBuilder<T> flipV(boolean flipV) {
        this.flipV = flipV;
        return this;
    }

    public ObjModelBuilder<T> emissiveAmbient(boolean ambientEmissive) {
        this.emissiveAmbient = ambientEmissive;
        return this;
    }

    public ObjModelBuilder<T> overrideMaterialLibrary(class_2960 mtlOverride) {
        Preconditions.checkNotNull((Object)mtlOverride, (Object)"mtlOverride must not be null");
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(mtlOverride, class_3264.field_14188), (String)"OBJ Model %s does not exist in any known resource pack", (Object)mtlOverride);
        this.mtlOverride = mtlOverride;
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        json.addProperty(PORTING_LIB_LOADER.toString(), PORTING_LIB_OBJ.toString());
        Preconditions.checkNotNull((Object)this.modelLocation, (Object)"modelLocation must not be null");
        json.addProperty("model", this.modelLocation.toString());
        if (this.automaticCulling != null) {
            json.addProperty("automatic_culling", this.automaticCulling);
        }
        if (this.shadeQuads != null) {
            json.addProperty("shade_quads", this.shadeQuads);
        }
        if (this.flipV != null) {
            json.addProperty("flip_v", this.flipV);
        }
        if (this.emissiveAmbient != null) {
            json.addProperty("emissive_ambient", this.emissiveAmbient);
        }
        if (this.mtlOverride != null) {
            json.addProperty("mtl_override", this.mtlOverride.toString());
        }
        return json;
    }
}

