/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.events.OnBabySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

public class BreedingTwins
extends BonusComponent<AccessoryItem> {
    static class_1296 LAST_CHILD = null;
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);

    public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
        return handler -> new BreedingTwins(handler, chance);
    }

    protected BreedingTwins(BonusHandler<AccessoryItem> handler, float chance) {
        super(handler);
        this.chance.set(chance, (Range<Float>)Range.CHANCE);
        OnBabySpawned.listen(this::spawnTwins).addCondition(Condition.isLogicalServer()).addCondition(data -> data.player != null).addCondition(data -> data.child != LAST_CHILD);
        this.addTooltip("majruszsaccessories.bonuses.spawn_twins", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("breeding_twins", this.chance::define);
    }

    private void spawnTwins(OnBabySpawned data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        LAST_CHILD = data.parentA.method_5613(data.getServerLevel(), (class_1296)data.parentB);
        if (LAST_CHILD == null) {
            return;
        }
        LAST_CHILD.method_7217(true);
        LAST_CHILD.method_5641(data.parentA.method_23317(), data.parentA.method_23318(), data.parentA.method_23321(), 0.0f, 0.0f);
        data.getLevel().method_8649((class_1297)LAST_CHILD);
        Events.dispatch((Object)new OnBabySpawned(data.parentA, data.parentB, LAST_CHILD, data.player));
        this.spawnEffects(data, LAST_CHILD, holder);
    }

    private void spawnEffects(OnBabySpawned data, class_1296 child, AccessoryHolder holder) {
        holder.getParticleEmitter().count(4).sizeBased((class_1297)child).emit((class_1937)data.getServerLevel());
    }
}

