/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.SerializableObject;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnPlayerWakedUp;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.config.RangedInteger;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;

public class SleepingBonuses
extends BonusComponent<AccessoryItem> {
    RangedFloat count = new RangedFloat().id("count").maxRange((Range<Float>)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(100.0f)));
    RangedInteger duration = new RangedInteger().id("duration").maxRange((Range<Integer>)Range.of((Number)1, (Number)10000));
    List<EffectDef> effects = List.of(new EffectDef(class_1294.field_5924, 0), new EffectDef(class_1294.field_5922, 0), new EffectDef(class_1294.field_5898, 1), new EffectDef(class_1294.field_5907, 0), new EffectDef(class_1294.field_5918, 0), new EffectDef(class_1294.field_5904, 0), new EffectDef(class_1294.field_5917, 0), new EffectDef(class_1294.field_5910, 0));

    public static BonusComponent.ISupplier<AccessoryItem> create(float count, int duration) {
        return handler -> new SleepingBonuses(handler, count, duration);
    }

    protected SleepingBonuses(BonusHandler<AccessoryItem> handler, float count, int duration) {
        super(handler);
        this.count.set(count, (Range<Float>)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(10.0f)));
        this.duration.set(duration, (Range<Integer>)Range.of((Number)1, (Number)10000));
        OnPlayerWakedUp.listen(this::applyBonuses).addCondition(Condition.isLogicalServer()).addCondition(data -> !data.wasSleepStoppedManually);
        this.addTooltip("majruszsaccessories.bonuses.sleep_bonuses", TooltipHelper.asValue(this.count).scaleOnlyOnDetailed(), TooltipHelper.asValue(this.duration));
        handler.getConfig().define("sleep_bonuses", subconfig -> {
            this.count.define((SerializableObject<?>)subconfig);
            this.duration.define((SerializableObject<?>)subconfig);
            subconfig.define("effects", Reader.list((IReader)Reader.custom(EffectDef::new)), s -> this.effects, (s, v) -> {
                this.effects = v;
            });
        });
    }

    private void applyBonuses(OnPlayerWakedUp data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        int count = Math.round(holder.apply(this.count));
        int duration = TimeHelper.toTicks((double)holder.apply(this.duration));
        this.getRandomMobEffects(data.player, count).forEach(effect -> data.player.method_6092(new class_1293(effect.effect, duration, effect.amplifier)));
        this.spawnEffects(data, holder);
    }

    private List<EffectDef> getRandomMobEffects(class_1657 player, int count) {
        List<EffectDef> missingEffects = this.effects.stream().filter(effect -> !player.method_6059(effect.effect)).toList();
        if (missingEffects.isEmpty()) {
            missingEffects = this.effects;
        }
        return Random.next(missingEffects, (int)count);
    }

    private void spawnEffects(OnPlayerWakedUp data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(5).position(data.player.method_19538()).emit((class_1937)data.getServerLevel());
    }

    private static class EffectDef {
        private class_1291 effect;
        private int amplifier;

        public EffectDef(class_1291 effect, int amplifier) {
            this.effect = effect;
            this.amplifier = amplifier;
        }

        public EffectDef() {
        }

        static {
            Serializables.get(EffectDef.class).define("id", Reader.mobEffect(), s -> s.effect, (s, v) -> {
                s.effect = v;
            }).define("amplifier", Reader.integer(), s -> s.amplifier, (s, v) -> {
                s.amplifier = v;
            });
        }
    }
}

