/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.config.Config;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.recipes.RecipeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class AccessoryRecipe
extends class_1852 {
    final AccessoryItem result;
    final List<AccessoryItem> ingredients;

    public static Supplier<class_1865<?>> create() {
        return Serializer::new;
    }

    public AccessoryRecipe(class_2960 id, AccessoryItem result, List<AccessoryItem> ingredients) {
        super(id, class_7710.field_40250);
        this.result = result;
        this.ingredients = ingredients;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(class_8566 container, class_1937 level) {
        RecipeData data = RecipeData.build(container);
        if (data.getCardsSize() != 0) return false;
        if (data.getBoostersSize() != 0) return false;
        if (data.getAccessoriesSize() != this.ingredients.size()) return false;
        if (!this.ingredients.stream().allMatch(data::hasAccessory)) return false;
        return true;
    }

    public class_1799 assemble(class_8566 container, class_5455 registryAccess) {
        RecipeData data = RecipeData.build(container);
        float average = data.getAverageBonus();
        float std = data.getStandardDeviation();
        float minBonus = ((Float)Config.Efficiency.RANGE.clamp((Number)Float.valueOf(average - std))).floatValue();
        float maxBonus = ((Float)Config.Efficiency.RANGE.clamp((Number)Float.valueOf(average + std))).floatValue();
        return AccessoryHolder.create(this.result).setBonus((Range<Float>)Range.of((Number)Float.valueOf(minBonus), (Number)Float.valueOf(maxBonus))).getItemStack();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public class_1865<?> method_8119() {
        return (class_1865)MajruszsAccessories.ACCESSORY_RECIPE.get();
    }

    public static class Serializer
    implements class_1865<AccessoryRecipe> {
        public AccessoryRecipe fromJson(class_2960 id, JsonObject object) {
            AccessoryItem result = (AccessoryItem)class_3518.method_15288((JsonObject)object, (String)"result");
            List<AccessoryItem> ingredients = Serializer.serializeIngredients(class_3518.method_15261((JsonObject)object, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for accessory recipe");
            }
            return new AccessoryRecipe(id, result, ingredients);
        }

        public AccessoryRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            int size = buffer.method_10816();
            ArrayList<AccessoryItem> ingredients = new ArrayList<AccessoryItem>();
            for (int idx = 0; idx < size; ++idx) {
                ingredients.add((AccessoryItem)buffer.method_10819().method_7909());
            }
            AccessoryItem result = (AccessoryItem)buffer.method_10819().method_7909();
            return new AccessoryRecipe(id, result, ingredients);
        }

        public void toNetwork(class_2540 buffer, AccessoryRecipe recipe) {
            buffer.method_10804(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> buffer.method_10793(new class_1799((class_1935)ingredient)));
            buffer.method_10793(new class_1799((class_1935)recipe.result));
        }

        private static List<AccessoryItem> serializeIngredients(JsonArray array) {
            ArrayList<AccessoryItem> ingredients = new ArrayList<AccessoryItem>();
            for (int i = 0; i < array.size(); ++i) {
                ingredients.add((AccessoryItem)class_3518.method_15256((JsonElement)array.get(i), (String)"item"));
            }
            return ingredients;
        }
    }
}

