/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
extends BlockTypeRegistry<WoodType> {
    public static final WoodTypeRegistry INSTANCE = new WoodTypeRegistry();
    @Deprecated(forRemoval=true)
    public static final WoodType OAK_TYPE = VanillaWoodTypes.OAK;
    private final Map<class_4719, WoodType> fromVanilla = new IdentityHashMap<class_4719, WoodType>();
    public static Set<String> BLACKLISTED_MODS = new HashSet<String>(Set.of("chipped", "compressedblocks", "securitycraft", "absentbydesign", "immersive_weathering", "dynamictrees", "dt"));

    @Deprecated(forRemoval=true)
    public static Collection<WoodType> getTypes() {
        return INSTANCE.getValues();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static WoodType getValue(class_2960 woodTypeId) {
        return (WoodType)INSTANCE.get(woodTypeId);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static WoodType getValue(String woodTypeId) {
        return (WoodType)INSTANCE.get(new class_2960(woodTypeId));
    }

    @Deprecated(forRemoval=true)
    public static WoodType fromNBT(String name) {
        return (WoodType)INSTANCE.getFromNBT(name);
    }

    @Deprecated(forRemoval=true)
    public static WoodType fromVanilla(class_4719 vanillaType) {
        return INSTANCE.getFromVanilla(vanillaType);
    }

    public WoodTypeRegistry() {
        super(WoodType.class, "wood_type");
        this.addFinder(() -> {
            WoodType b = new WoodType(new class_2960("bamboo"), class_2246.field_40294, class_2246.field_41072);
            b.addChild("stripped_log", class_2246.field_41073);
            return Optional.of(b);
        });
    }

    @Override
    protected WoodType register(WoodType vanillaType) {
        return super.register(vanillaType);
    }

    @Override
    public WoodType getDefaultType() {
        return VanillaWoodTypes.OAK;
    }

    @Override
    public Optional<WoodType> detectTypeFromBlock(class_2248 baseBlock, class_2960 baseRes) {
        class_2680 state;
        String name = null;
        String path = baseRes.method_12832();
        if (baseRes.method_12836().equals("tfc") || baseRes.method_12836().equals("afc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = class_7923.field_41175.method_17966(new class_2960(baseRes.method_12836(), path.replace("planks", "log")))).isPresent()) {
                class_2960 id = new class_2960(baseRes.method_12836(), path.replace("wood/planks/", ""));
                return Optional.of(new WoodType(id, baseBlock, (class_2248)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = baseRes.method_12836();
        if (name != null && !BLACKLISTED_MODS.contains(namespace) && (state = baseBlock.method_9564()).method_28501().size() <= 2 && !(baseBlock instanceof class_2482)) {
            name = name.replace("/", "_");
            class_2960 id = new class_2960(baseRes.method_12836(), name);
            class_2248 logBlock = WoodType.findLog(id);
            if (logBlock != null && !this.valuesReg.containsKey(id)) {
                return Optional.of(new WoodType(id, baseBlock, logBlock));
            }
        }
        return Optional.empty();
    }

    @Nullable
    public WoodType getFromVanilla(class_4719 woodType) {
        if (this.fromVanilla.isEmpty()) {
            for (WoodType w : this.getValues()) {
                class_4719 vanilla = w.toVanilla();
                if (vanilla == null) continue;
                this.fromVanilla.put(vanilla, w);
            }
        }
        return this.fromVanilla.get(woodType);
    }

    public WoodType.Finder addSimpleFinder(class_2960 woodTypeId) {
        WoodType.Finder finder = new WoodType.Finder(woodTypeId);
        this.addFinder(finder);
        return finder;
    }

    public WoodType.Finder addSimpleFinder(String nameWoodType) {
        return this.addSimpleFinder(new class_2960(nameWoodType));
    }

    public WoodType.Finder addSimpleFinder(String namespace, String nameWoodType) {
        return this.addSimpleFinder(new class_2960(namespace, nameWoodType));
    }
}

