/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.audio;

import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import dev.mrturtle.analog.AnalogPlugin;
import dev.mrturtle.analog.ModBlocks;
import dev.mrturtle.analog.audio.PlayerAudioData;
import dev.mrturtle.analog.audio.RadioAudioInstance;
import dev.mrturtle.analog.audio.ReceiverAudioData;
import dev.mrturtle.analog.block.ReceiverBlockEntity;
import dev.mrturtle.analog.util.RadioUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class RadioAudioManager {
    public final ArrayList<RadioAudioInstance> activeAudioInstances = new ArrayList();
    public final HashMap<class_2338, HashMap<class_2338, RadioAudioInstance>> transmitterAudioInstances = new HashMap();
    public final HashMap<class_2338, ArrayList<ReceiverAudioData>> receiverAudioPlayers = new HashMap();
    public final HashMap<class_3222, ArrayList<PlayerAudioData>> playerAudioPlayers = new HashMap();

    public void tick(class_3218 world) {
        ArrayList<PlayerAudioData> audioPlayers;
        this.activeAudioInstances.removeIf(audioInstance -> audioInstance.isDone);
        for (class_3222 class_32222 : world.method_18456()) {
            for (RadioAudioInstance radioAudioInstance : this.activeAudioInstances) {
                if (RadioUtil.isReceivingChannel((class_1657)class_32222, radioAudioInstance.channel)) {
                    this.playerReceiverTurnedOn(class_32222, radioAudioInstance.channel);
                    continue;
                }
                this.playerReceiverTurnedOff(class_32222, radioAudioInstance.channel);
            }
            if (!this.playerAudioPlayers.containsKey(class_32222)) continue;
            audioPlayers = this.playerAudioPlayers.get(class_32222);
            audioPlayers.forEach(audioData -> {
                if (audioData.channel != audioData.instance.channel || audioData.instance.isDone) {
                    audioData.audioPlayer.stopPlaying();
                }
            });
            audioPlayers.removeIf(audioData -> audioData.audioPlayer.isStopped());
            for (PlayerAudioData audioData2 : audioPlayers) {
                audioData2.audioChannel.updateLocation(AnalogPlugin.API.createPosition(class_32222.method_23317(), class_32222.method_23318(), class_32222.method_23321()));
            }
        }
        for (Map.Entry entry : this.receiverAudioPlayers.entrySet()) {
            class_2338 class_23382;
            audioPlayers = (ArrayList<PlayerAudioData>)entry.getValue();
            audioPlayers.forEach((Consumer<PlayerAudioData>)((Consumer<ReceiverAudioData>)audioData -> {
                if (audioData.channel != audioData.instance.channel || audioData.instance.isDone) {
                    audioData.audioPlayer.stopPlaying();
                }
            }));
            audioPlayers.removeIf(audioData -> audioData.audioPlayer.isStopped());
            if (audioPlayers.isEmpty() || !world.method_22340(class_23382 = (class_2338)entry.getKey())) continue;
            ReceiverBlockEntity receiver = (ReceiverBlockEntity)world.method_8321(class_23382);
            receiver.lastAudioPlayedTick = world.method_8510();
            world.method_8452(class_23382, ModBlocks.RECEIVER_BLOCK);
        }
        for (class_2338 class_23383 : RadioUtil.getGlobalRadioState(world).getReceivers()) {
            ReceiverBlockEntity receiver;
            if (!world.method_22340(class_23383) || (receiver = (ReceiverBlockEntity)world.method_8321(class_23383)) == null || !receiver.enabled) continue;
            if (!this.receiverAudioPlayers.containsKey(class_23383)) {
                this.receiverTurnedOn(world, class_23383, receiver.channel);
                continue;
            }
            ArrayList<ReceiverAudioData> arrayList = this.receiverAudioPlayers.get(class_23383);
            for (RadioAudioInstance instance : this.activeAudioInstances) {
                if (instance.channel != receiver.channel) continue;
                boolean alreadyPlaying = false;
                for (ReceiverAudioData audioPlayer : arrayList) {
                    if (audioPlayer.instance != instance) continue;
                    alreadyPlaying = true;
                }
                if (alreadyPlaying) continue;
                this.startReceivingAudioInstance(world, class_23383, instance);
            }
        }
    }

    public void receiverTurnedOn(class_3218 world, class_2338 pos, int receivingChannel) {
        for (RadioAudioInstance instance : this.activeAudioInstances) {
            if (instance.channel != receivingChannel) continue;
            this.startReceivingAudioInstance(world, pos, instance);
        }
    }

    public void receiverTurnedOff(class_2338 pos) {
        ArrayList<ReceiverAudioData> audioPlayers = this.receiverAudioPlayers.remove(pos);
        if (audioPlayers == null) {
            return;
        }
        for (ReceiverAudioData audioData : audioPlayers) {
            if (!audioData.audioPlayer.isPlaying()) continue;
            audioData.audioPlayer.stopPlaying();
        }
        this.receiverAudioPlayers.remove(pos);
    }

    public void playerReceiverTurnedOn(class_3222 player, int receivingChannel) {
        ArrayList audioPlayers = this.playerAudioPlayers.computeIfAbsent(player, playerEntity -> new ArrayList());
        for (RadioAudioInstance instance : this.activeAudioInstances) {
            if (instance.channel != receivingChannel) continue;
            boolean alreadyExists = false;
            for (PlayerAudioData audioData : audioPlayers) {
                if (audioData.instance != instance) continue;
                alreadyExists = true;
                break;
            }
            if (alreadyExists) continue;
            this.startReceivingAudioInstance(player.method_51469(), player, instance);
        }
    }

    public void playerReceiverTurnedOff(class_3222 player, int receivingChannel) {
        ArrayList<PlayerAudioData> audioPlayers = this.playerAudioPlayers.get(player);
        if (audioPlayers == null) {
            return;
        }
        ArrayList<PlayerAudioData> toBeRemoved = new ArrayList<PlayerAudioData>();
        for (PlayerAudioData audioData : audioPlayers) {
            if (audioData.channel != receivingChannel) continue;
            audioData.audioPlayer.stopPlaying();
            toBeRemoved.add(audioData);
        }
        for (PlayerAudioData audioData : toBeRemoved) {
            audioPlayers.remove(audioData);
        }
        this.playerAudioPlayers.remove(player);
    }

    public void startReceivingAudioInstance(class_3218 world, class_2338 pos, RadioAudioInstance instance) {
        VoicechatServerApi serverApi = AnalogPlugin.API;
        LocationalAudioChannel channel = serverApi.createLocationalAudioChannel(UUID.randomUUID(), serverApi.fromServerLevel((Object)world), serverApi.createPosition(pos.method_46558().method_10216(), pos.method_46558().method_10214(), pos.method_46558().method_10215()));
        if (channel == null) {
            return;
        }
        channel.setDistance(24.0f);
        channel.setCategory(AnalogPlugin.RADIO_CATEGORY);
        AudioPlayer audioPlayer = serverApi.createAudioPlayer((AudioChannel)channel, serverApi.createEncoder(), instance.audioSupplier);
        audioPlayer.startPlaying();
        ArrayList audioPlayers = this.receiverAudioPlayers.computeIfAbsent(pos, blockPos -> new ArrayList());
        audioPlayers.add(new ReceiverAudioData(audioPlayer, instance));
    }

    public void startReceivingAudioInstance(class_3218 world, class_3222 player, RadioAudioInstance instance) {
        VoicechatServerApi serverApi = AnalogPlugin.API;
        LocationalAudioChannel channel = serverApi.createLocationalAudioChannel(UUID.randomUUID(), serverApi.fromServerLevel((Object)world), serverApi.createPosition(player.method_23317(), player.method_23318(), player.method_23321()));
        if (channel == null) {
            return;
        }
        channel.setDistance(8.0f);
        channel.setCategory(AnalogPlugin.RADIO_CATEGORY);
        AudioPlayer audioPlayer = serverApi.createAudioPlayer((AudioChannel)channel, serverApi.createEncoder(), instance.audioSupplier);
        audioPlayer.startPlaying();
        ArrayList audioPlayers = this.playerAudioPlayers.computeIfAbsent(player, playerEntity -> new ArrayList());
        audioPlayers.add(new PlayerAudioData(audioPlayer, channel, instance));
    }

    public void changeTransmitterChannel(class_2338 pos, int newChannel) {
        HashMap<class_2338, RadioAudioInstance> audioInstances = this.transmitterAudioInstances.get(pos);
        if (audioInstances == null) {
            return;
        }
        for (RadioAudioInstance audioInstance : audioInstances.values()) {
            audioInstance.channel = newChannel;
        }
    }

    public void stopTransmitter(class_2338 pos, class_2338 jukeboxPos) {
        HashMap<class_2338, RadioAudioInstance> audioInstances = this.transmitterAudioInstances.get(pos);
        if (audioInstances == null) {
            return;
        }
        if (audioInstances.containsKey(jukeboxPos)) {
            this.stopAudioInstance(audioInstances.get(jukeboxPos));
            audioInstances.remove(jukeboxPos);
        }
    }

    public void stopTransmitter(class_2338 pos) {
        HashMap<class_2338, RadioAudioInstance> audioInstances = this.transmitterAudioInstances.get(pos);
        if (audioInstances == null) {
            return;
        }
        for (RadioAudioInstance instance : audioInstances.values()) {
            this.stopAudioInstance(instance);
        }
        audioInstances.clear();
    }

    public void stopAudioInstance(RadioAudioInstance instance) {
        instance.interrupt();
        for (ArrayList<ReceiverAudioData> arrayList : this.receiverAudioPlayers.values()) {
            for (Object audioData : arrayList) {
                ((ReceiverAudioData)audioData).audioPlayer.stopPlaying();
            }
        }
        for (ArrayList<Object> arrayList : this.playerAudioPlayers.values()) {
            for (Object audioData : arrayList) {
                ((PlayerAudioData)audioData).audioPlayer.stopPlaying();
            }
        }
    }
}

