/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.FileHandler;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.render.map.TileDrawStep;
import journeymap.client.render.map.TileDrawStepCache;
import journeymap.client.texture.ImageUtil;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1011;
import net.minecraft.class_1923;

public class RegionImageHandler {
    public static File getImageDir(RegionCoord rCoord, MapType mapType) {
        File dimDir = rCoord.dimDir.toFile();
        File subDir = null;
        subDir = mapType.isUnderground() ? new File(dimDir, Integer.toString(mapType.vSlice)) : new File(dimDir, mapType.name());
        if (!subDir.exists()) {
            subDir.mkdirs();
        }
        return subDir;
    }

    public static File getRegionImageFile(RegionCoord rCoord, MapType mapType) {
        StringBuffer sb = new StringBuffer();
        sb.append(rCoord.regionX).append(",").append(rCoord.regionZ).append(".png");
        File regionFile = new File(RegionImageHandler.getImageDir(rCoord, mapType), sb.toString());
        return regionFile;
    }

    public static class_1011 readRegionImage(File regionFile) {
        if (regionFile.canRead()) {
            try {
                class_1011 image = RegionImageHandler.getImage(regionFile);
                return image;
            }
            catch (Exception e) {
                String error = "Region file produced error: " + regionFile + ": " + LogFormatter.toPartialString(e);
                Journeymap.getLogger().error(error);
            }
        }
        return null;
    }

    public static class_1011 getImage(File file) {
        try {
            FileInputStream is = new FileInputStream(file.getPath());
            return class_1011.method_4309((InputStream)is);
        }
        catch (IOException e) {
            String error = "Could not get image from file: " + file + ": " + e.getMessage();
            Journeymap.getLogger().error(error);
            return null;
        }
    }

    public static synchronized class_1011 getMergedChunks(File worldDir, class_1923 startCoord, class_1923 endCoord, MapType mapType, Boolean useCache, class_1011 image, Integer imageWidth, Integer imageHeight, boolean allowNullImage, boolean showGrid) {
        int scale = 1;
        scale = Math.max(scale, 1);
        int initialWidth = Math.min(512, (endCoord.field_9181 - startCoord.field_9181 + 1) * 16 / scale);
        int initialHeight = Math.min(512, (endCoord.field_9180 - startCoord.field_9180 + 1) * 16 / scale);
        image = new class_1011(initialWidth, initialHeight, false);
        RegionImageCache cache = RegionImageCache.INSTANCE;
        RegionCoord rc = null;
        class_1011 regionImage = null;
        int rx1 = RegionCoord.getRegionPos(startCoord.field_9181);
        int rx2 = RegionCoord.getRegionPos(endCoord.field_9181);
        int rz1 = RegionCoord.getRegionPos(startCoord.field_9180);
        int rz2 = RegionCoord.getRegionPos(endCoord.field_9180);
        boolean imageDrawn = false;
        for (int rx = rx1; rx <= rx2; ++rx) {
            for (int rz = rz1; rz <= rz2; ++rz) {
                rc = new RegionCoord(worldDir, rx, rz, mapType.dimension);
                regionImage = cache.getRegionImageSet(rc).getImage(mapType);
                if (regionImage == null) continue;
                int rminCx = Math.max(rc.getMinChunkX(), startCoord.field_9181);
                int rminCz = Math.max(rc.getMinChunkZ(), startCoord.field_9180);
                int rmaxCx = Math.min(rc.getMaxChunkX(), endCoord.field_9181);
                int rmaxCz = Math.min(rc.getMaxChunkZ(), endCoord.field_9180);
                int xoffset = rc.getMinChunkX() * 16;
                int yoffset = rc.getMinChunkZ() * 16;
                int sx1 = rminCx * 16 - xoffset;
                int sy1 = rminCz * 16 - yoffset;
                int sx2 = sx1 + (rmaxCx - rminCx + 1) * 16;
                int sy2 = sy1 + (rmaxCz - rminCz + 1) * 16;
                xoffset = startCoord.field_9181 * 16;
                yoffset = startCoord.field_9180 * 16;
                int dx1 = startCoord.field_9181 * 16 - xoffset;
                int dy1 = startCoord.field_9180 * 16 - yoffset;
                int dx2 = dx1 + (endCoord.field_9181 - startCoord.field_9181 + 1) * 16;
                int dy2 = dy1 + (endCoord.field_9180 - startCoord.field_9180 + 1) * 16;
                for (int x = 0; x < sx2; ++x) {
                    for (int y = 0; y < sy2; ++y) {
                        int pixel = regionImage.method_4315(x, y);
                        image.method_4305(x, y, pixel);
                    }
                }
                imageDrawn = true;
            }
        }
        if (imageDrawn && showGrid) {
            int color = mapType.isDay() ? RGB.toArbg(0, 0.25f) : RGB.toArbg(0x808080, 0.1f);
            for (int y = 0; y < initialHeight; y += 16) {
                for (int x = 0; x < initialWidth; ++x) {
                    image.method_35624(x, y, color);
                }
            }
            for (int x = 0; x < initialWidth; x += 16) {
                for (int y = 0; y < initialHeight; ++y) {
                    image.method_35624(x, y, color);
                }
            }
        }
        if (allowNullImage && !imageDrawn) {
            return null;
        }
        if (imageHeight != null && imageWidth != null && (initialHeight != imageHeight || initialWidth != imageWidth)) {
            return ImageUtil.getSizedImage(imageWidth, imageHeight, image, true);
        }
        return image;
    }

    public static synchronized List<TileDrawStep> getTileDrawSteps(File worldDir, class_1923 startCoord, class_1923 endCoord, MapType mapType, Integer zoom, boolean highQuality) {
        boolean isUnderground = mapType.isUnderground();
        int rx1 = RegionCoord.getRegionPos(startCoord.field_9181);
        int rx2 = RegionCoord.getRegionPos(endCoord.field_9181);
        int rz1 = RegionCoord.getRegionPos(startCoord.field_9180);
        int rz2 = RegionCoord.getRegionPos(endCoord.field_9180);
        ArrayList<TileDrawStep> drawSteps = new ArrayList<TileDrawStep>();
        for (int rx = rx1; rx <= rx2; ++rx) {
            for (int rz = rz1; rz <= rz2; ++rz) {
                RegionCoord rc = new RegionCoord(worldDir, rx, rz, mapType.dimension);
                int rminCx = Math.max(rc.getMinChunkX(), startCoord.field_9181);
                int rminCz = Math.max(rc.getMinChunkZ(), startCoord.field_9180);
                int rmaxCx = Math.min(rc.getMaxChunkX(), endCoord.field_9181);
                int rmaxCz = Math.min(rc.getMaxChunkZ(), endCoord.field_9180);
                int xoffset = rc.getMinChunkX() * 16;
                int yoffset = rc.getMinChunkZ() * 16;
                int sx1 = rminCx * 16 - xoffset;
                int sy1 = rminCz * 16 - yoffset;
                int sx2 = sx1 + (rmaxCx - rminCx + 1) * 16;
                int sy2 = sy1 + (rmaxCz - rminCz + 1) * 16;
                drawSteps.add(TileDrawStepCache.getOrCreate(mapType, rc, zoom, highQuality, sx1, sy1, sx2, sy2));
            }
        }
        return drawSteps;
    }

    public static File getBlank512x512ImageFile() {
        File dataDir = new File(FileHandler.MinecraftDirectory, Constants.DATA_DIR);
        File tmpFile = new File(dataDir, "blank512x512.png");
        if (!tmpFile.canRead()) {
            try (class_1011 image = ImageUtil.getNewBlankImage(512, 512);){
                dataDir.mkdirs();
                image.method_4325(tmpFile);
                tmpFile.setReadOnly();
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Could not create blank temp file " + tmpFile + ": " + LogFormatter.toString(e));
            }
        }
        return tmpFile;
    }
}

