/*
 * Decompiled with CFR 0.152.
 */
package crab.backport.block;

import crab.backport.block.CrabsBackportTags;
import crab.backport.block.InteractibleSlotContainer;
import crab.backport.block.SideChainPart;
import crab.backport.block.SideChaining;
import crab.backport.block.entity.ListInventory;
import crab.backport.block.entity.ShelfBlockEntity;
import crab.backport.sound.CrabsBackportSounds;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends class_2237
implements InteractibleSlotContainer,
SideChaining,
class_3737 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2754<SideChainPart> SIDE_CHAIN = class_2754.method_11850((String)"side_chain", SideChainPart.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)4.0, (double)16.0)});
    protected static final class_265 WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)11.0, (double)12.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), (class_265[])new class_265[]{class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)11.0, (double)0.0, (double)0.0, (double)13.0, (double)4.0, (double)16.0)});
    protected static final class_265 SOUTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)5.0)});
    protected static final class_265 NORTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)12.0, (double)11.0, (double)16.0, (double)16.0, (double)13.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)4.0, (double)13.0)});

    public ShelfBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657(SIDE_CHAIN, (Comparable)((Object)SideChainPart.UNCONNECTED))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch ((class_2350)state.method_11654(FACING)) {
            default: {
                return NORTH_SHAPE;
            }
            case field_11035: {
                return SOUTH_SHAPE;
            }
            case field_11039: {
                return WEST_SHAPE;
            }
            case field_11034: 
        }
        return EAST_SHAPE;
    }

    public boolean method_9526(class_2680 state) {
        return true;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return type == class_10.field_48 && state.method_26227().method_15767(class_3486.field_15517);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ShelfBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWERED, SIDE_CHAIN, WATERLOGGED});
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof ListInventory) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((ListInventory)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
            this.disconnectNeighbors((class_1936)world, pos, state);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (!world.method_8608()) {
            boolean bl = world.method_49803(pos);
            if ((Boolean)state.method_11654((class_2769)POWERED) != bl) {
                class_2680 blockState = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(bl));
                if (!bl) {
                    blockState = (class_2680)blockState.method_11657(SIDE_CHAIN, (Comparable)((Object)SideChainPart.UNCONNECTED));
                }
                world.method_8652(pos, blockState, 3);
                this.playSound((class_1936)world, pos, bl ? CrabsBackportSounds.BLOCK_SHELF_ACTIVATE : CrabsBackportSounds.BLOCK_SHELF_DEACTIVATE);
                world.method_43276(bl ? class_5712.field_28174 : class_5712.field_28175, pos, class_5712.class_7397.method_43287((class_2680)blockState));
            }
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(ctx.method_8045().method_49803(ctx.method_8037())))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    @Override
    public int getRows() {
        return 1;
    }

    @Override
    public int getColumns() {
        return 3;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)class_25862;
            if (!hand.equals((Object)class_1268.field_5810)) {
                OptionalInt optionalInt = this.getHitSlot(hit, (class_2350)state.method_11654(FACING));
                if (optionalInt.isEmpty()) {
                    return class_1269.field_5811;
                }
                class_1661 playerInventory = player.method_31548();
                if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                    class_1799 itemStack = playerInventory.method_7391();
                    this.swapAllStacks(world, pos, playerInventory);
                    this.playSound((class_1936)world, pos, CrabsBackportSounds.BLOCK_SHELF_MULTI_SWAP);
                    return itemStack == playerInventory.method_7391() ? class_1269.field_5812 : class_1269.field_21466;
                }
                class_1799 stack = playerInventory.method_7391();
                boolean bl = ShelfBlock.swapSingleStack(stack, player, shelfBlockEntity, optionalInt, playerInventory);
                if (bl && !stack.method_7960()) {
                    this.playSound((class_1936)world, pos, CrabsBackportSounds.BLOCK_SHELF_SINGLE_SWAP);
                } else if (bl || !stack.method_7960()) {
                    this.playSound((class_1936)world, pos, CrabsBackportSounds.BLOCK_SHELF_PLACE_ITEM);
                }
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5811;
    }

    private static boolean swapSingleStack(class_1799 stack, class_1657 player, ShelfBlockEntity blockEntity, OptionalInt slot, class_1661 playerInventory) {
        class_1799 itemStack2;
        class_1799 itemStack = blockEntity.swapStackNoMarkDirty(slot.getAsInt(), stack);
        class_1799 class_17992 = itemStack2 = player.method_7337() && itemStack.method_7960() ? stack.method_7972() : itemStack;
        if (player.method_6047() == stack) {
            player.method_6122(class_1268.field_5808, itemStack2);
        }
        playerInventory.method_5431();
        blockEntity.markDirty(class_5712.field_28146);
        return !itemStack.method_7960();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    private void swapAllStacks(class_1937 world, class_2338 pos, class_1661 playerInventory) {
        List list = this.getPositionsInChain((class_1936)world, pos);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)world.method_8321((class_2338)list.get(i));
                if (shelfBlockEntity == null) continue;
                for (int j = 0; j < shelfBlockEntity.method_5439(); ++j) {
                    int k = 9 - (list.size() - i) * shelfBlockEntity.method_5439() + j;
                    class_1799 itemStack = shelfBlockEntity.swapStackNoMarkDirty(j, playerInventory.method_5441(k));
                    playerInventory.method_5447(k, itemStack);
                }
                playerInventory.method_5431();
                playerInventory.method_5431();
                shelfBlockEntity.markDirty(class_5712.field_28725);
            }
        }
    }

    @Override
    public SideChainPart getSideChainPart(class_2680 state) {
        return (SideChainPart)((Object)state.method_11654(SIDE_CHAIN));
    }

    @Override
    public class_2680 withSideChainPart(class_2680 state, SideChainPart sideChainPart) {
        return (class_2680)state.method_11657(SIDE_CHAIN, (Comparable)((Object)sideChainPart));
    }

    @Override
    public class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654(FACING);
    }

    @Override
    public boolean canChainWith(class_2680 state) {
        return state.method_26164(CrabsBackportTags.Blocks.WOODEN_SHELVES) && (Boolean)state.method_11654((class_2769)POWERED) != false;
    }

    @Override
    public int getMaxSideChainLength() {
        return 3;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            this.connectNeighbors((class_1936)world, pos, state, oldState);
        } else {
            this.disconnectNeighbors((class_1936)world, pos, state);
        }
    }

    private void playSound(class_1936 world, class_2338 pos, class_3414 sound) {
        world.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2350 direction = this.getFacing(state);
        if (world.method_8608()) {
            return 0;
        }
        if (direction != ((class_2350)state.method_11654(FACING)).method_10153()) {
            return 0;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBlockEntity = (ShelfBlockEntity)class_25862;
            int i = shelfBlockEntity.method_5438(0).method_7960() ? 0 : 1;
            int j = shelfBlockEntity.method_5438(1).method_7960() ? 0 : 1;
            int k = shelfBlockEntity.method_5438(2).method_7960() ? 0 : 1;
            return i | j << 1 | k << 2;
        }
        return 0;
    }
}

