/*
 * Decompiled with CFR 0.152.
 */
package crab.backport.world.gen.features;

import com.mojang.serialization.Codec;
import crab.backport.world.gen.features.FallenTreeFeatureConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3746;
import net.minecraft.class_4662;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class FallenTreeFeature
extends class_3031<FallenTreeFeatureConfig> {
    public FallenTreeFeature(Codec<FallenTreeFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<FallenTreeFeatureConfig> context) {
        this.generate((FallenTreeFeatureConfig)context.method_33656(), context.method_33655(), context.method_33652(), context.method_33654());
        return true;
    }

    private void generate(FallenTreeFeatureConfig config, class_2338 pos, class_5281 world, class_5819 random) {
        this.generateStump(config, world, random, pos.method_25503());
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        int i = config.logLength.method_35008(random) - 2;
        class_2338.class_2339 mutable = pos.method_10079(direction, 2 + random.method_43048(2)).method_25503();
        this.moveToGroundPos(world, mutable);
        if (this.canPlaceLog(world, i, mutable, direction)) {
            this.generateLog(config, world, random, i, mutable, direction);
        }
    }

    private void moveToGroundPos(class_5281 world, class_2338.class_2339 pos) {
        pos.method_10104(class_2350.field_11036, 1);
        for (int i = 0; i < 6; ++i) {
            if (this.canReplaceAndHasSolidBelow((class_1936)world, (class_2338)pos)) {
                return;
            }
            pos.method_10098(class_2350.field_11033);
        }
    }

    private void generateStump(FallenTreeFeatureConfig config, class_5281 world, class_5819 random, class_2338.class_2339 pos) {
        class_2338 blockPos = this.setBlockStateAndGetPos(config, world, random, pos, Function.identity());
        this.applyDecorators(world, random, Set.of(blockPos), config.stumpDecorators);
    }

    private boolean canPlaceLog(class_5281 world, int length, class_2338.class_2339 pos, class_2350 direction) {
        int i = 0;
        for (int j = 0; j < length; ++j) {
            if (!class_2944.method_27371((class_3746)world, (class_2338)pos)) {
                return false;
            }
            if (!this.isSolidBelow((class_1936)world, (class_2338)pos)) {
                if (++i > 2) {
                    return false;
                }
            } else {
                i = 0;
            }
            pos.method_10098(direction);
        }
        pos.method_10104(direction.method_10153(), length);
        return true;
    }

    private void generateLog(FallenTreeFeatureConfig config, class_5281 world, class_5819 random, int length, class_2338.class_2339 pos, class_2350 direction) {
        HashSet<class_2338> set = new HashSet<class_2338>();
        for (int i = 0; i < length; ++i) {
            set.add(this.setBlockStateAndGetPos(config, world, random, pos, FallenTreeFeature.createAxisApplier(direction)));
            pos.method_10098(direction);
        }
        this.applyDecorators(world, random, set, config.logDecorators);
    }

    private boolean canReplaceAndHasSolidBelow(class_1936 world, class_2338 pos) {
        return class_2944.method_27371((class_3746)world, (class_2338)pos) && this.isSolidBelow(world, pos);
    }

    private boolean isSolidBelow(class_1936 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26206((class_1922)world, pos, class_2350.field_11036);
    }

    private class_2338 setBlockStateAndGetPos(FallenTreeFeatureConfig config, class_5281 world, class_5819 random, class_2338.class_2339 pos, Function<class_2680, class_2680> stateFunction) {
        world.method_8652((class_2338)pos, stateFunction.apply(config.trunkProvider.method_23455(random, (class_2338)pos)), 3);
        this.method_37256(world, (class_2338)pos);
        return pos.method_10062();
    }

    private void applyDecorators(class_5281 world, class_5819 random, Set<class_2338> positions, List<class_4662> decorators) {
        if (!decorators.isEmpty()) {
            class_4662.class_7402 generator = new class_4662.class_7402((class_3746)world, this.createStatePlacer(world), random, positions, Set.of(), Set.of());
            decorators.forEach(decorator -> decorator.method_23469(generator));
        }
    }

    private BiConsumer<class_2338, class_2680> createStatePlacer(class_5281 world) {
        return (pos, state) -> world.method_8652(pos, state, 19);
    }

    private static Function<class_2680, class_2680> createAxisApplier(class_2350 direction) {
        return state -> (class_2680)state.method_47968((class_2769)class_2465.field_11459, (Comparable)direction.method_10166());
    }
}

