/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.gui;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_3728;
import org.jetbrains.annotations.Nullable;

public class StyledTextFieldHelper
extends class_3728 {
    private static final char TOKEN = '\u00a7';
    private final Supplier<String> getMessageFn;

    public StyledTextFieldHelper(Supplier<String> supplier, Consumer<String> consumer, Supplier<String> supplier2, Consumer<String> consumer2, Predicate<String> predicate) {
        super(supplier, consumer, supplier2, consumer2, predicate);
        this.getMessageFn = supplier;
    }

    public void method_42574(int direction, class_3728.class_7279 cursorStep) {
        boolean hasTokenAtCursor;
        String msg = this.getMessageFn.get();
        int cursorPos = this.method_16201();
        boolean bl = hasTokenAtCursor = cursorPos < msg.length() && msg.charAt(cursorPos) == '\u00a7';
        if (direction < 0) {
            int k = StyledTextFieldHelper.getIndexBeforeToken(direction, msg, cursorPos);
            if (cursorPos == msg.length() || hasTokenAtCursor) {
                direction = k;
            }
            super.method_42574(direction, cursorStep);
            if (k != direction) {
                this.method_42575(k + 1, false, cursorStep);
            }
        } else if (hasTokenAtCursor) {
            this.method_42575(direction, false, class_3728.class_7279.field_38308);
            this.method_42574(-1, cursorStep);
        } else {
            super.method_42574(direction, cursorStep);
        }
    }

    private static int getIndexBeforeToken(int i, String msg, int cursorPos) {
        int p = cursorPos - 3;
        if (p >= 0 && msg.length() > p && msg.charAt(p) == '\u00a7') {
            i = -3;
            int p1 = cursorPos - 5;
            if (p1 >= 0 && msg.charAt(p1) == '\u00a7') {
                i = -5;
            }
        }
        return i;
    }

    public void method_42575(int i, boolean keepSelection, class_3728.class_7279 cursorStep) {
        String msg = this.getMessageFn.get();
        int cursorPos = this.method_16201();
        if (i < 0) {
            i = StyledTextFieldHelper.getIndexBeforeToken(i, msg, cursorPos);
            super.method_42575(i, keepSelection, cursorStep);
        } else {
            if (cursorPos < msg.length() && msg.charAt(cursorPos) == '\u00a7') {
                i = 3;
                int p = cursorPos + 2;
                if (p < msg.length() && msg.charAt(p) == '\u00a7') {
                    i = 5;
                }
            }
            super.method_42575(i, keepSelection, class_3728.class_7279.field_38308);
        }
    }

    public void insertStyledText(String text, class_124 color, class_124 style) {
        String lastMod;
        String currentMod = this.getModifier(color, style);
        if (!Objects.equals(currentMod, lastMod = this.getPreviousModifier())) {
            String s = currentMod + text;
            this.method_16197(s);
            int j = this.method_16201();
            if (this.method_16201() != this.getMessageFn.get().length() && lastMod != null) {
                this.method_16197(lastMod);
                super.method_27560(j, false);
            }
        } else {
            this.method_16197(text);
        }
    }

    public void method_27560(int textIndex, boolean keepSelection) {
        String text = this.getMessageFn.get();
        super.method_27560(textIndex, keepSelection);
    }

    private String getModifier(class_124 color, class_124 style) {
        Object s = color.toString();
        if (style != class_124.field_1070) {
            s = (String)s + style.toString();
        }
        return ((String)s).replace('\u00a7', '\u00a7');
    }

    @Nullable
    private String getPreviousModifier() {
        int cursorPos;
        String text = this.getMessageFn.get();
        for (int i = cursorPos = this.method_16201() - 1; i >= 0 && i < text.length(); --i) {
            if (text.charAt(i) != '\u00a7') continue;
            int start = i;
            int end = i + 2;
            if (i >= 2 && text.charAt(i - 2) == '\u00a7') {
                start -= 2;
            }
            if (end > text.length()) continue;
            return text.substring(start, end);
        }
        return null;
    }

    public void formatSelected(@Nullable class_124 ink, @Nullable class_124 quill) {
    }
}

