/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import com.google.common.base.Strings;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.media.PrintoutMenu;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import org.jspecify.annotations.Nullable;

public class PrintoutItem
extends class_1792 {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_PAGES = "Pages";
    private static final String NBT_LINE_TEXT = "Text";
    private static final String NBT_LINE_COLOUR = "Color";
    public static final int LINES_PER_PAGE = 21;
    public static final int LINE_MAX_LENGTH = 25;
    public static final int MAX_PAGES = 16;

    public PrintoutItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 options) {
        String title = PrintoutItem.getTitle(stack);
        if (title != null && !title.isEmpty()) {
            list.add((class_2561)class_2561.method_43470((String)title));
        }
    }

    public class_1269 method_7884(class_1838 context) {
        return CustomLecternBlock.defaultUseItemOn(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            String title = PrintoutItem.getTitle(stack);
            class_2561 displayTitle = Strings.isNullOrEmpty((String)title) ? stack.method_7954() : class_2561.method_43470((String)title);
            player.method_17355((class_3908)new class_747((id, playerInventory, p) -> PrintoutMenu.createInHand(id, p, hand), displayTitle));
        }
        return new class_1271(class_1269.method_29236((boolean)world.field_9236), (Object)stack);
    }

    private class_1799 createFromTitleAndText(@Nullable String title, String @Nullable [] text, String @Nullable [] colours) {
        int i;
        class_2487 tag;
        class_1799 stack = new class_1799((class_1935)this);
        if (title != null) {
            stack.method_7948().method_10582(NBT_TITLE, title);
        }
        if (text != null) {
            tag = stack.method_7948();
            tag.method_10569(NBT_PAGES, text.length / 21);
            for (i = 0; i < text.length; ++i) {
                if (text[i] == null) continue;
                tag.method_10582(NBT_LINE_TEXT + i, text[i]);
            }
        }
        if (colours != null) {
            tag = stack.method_7948();
            for (i = 0; i < colours.length; ++i) {
                if (colours[i] == null) continue;
                tag.method_10582(NBT_LINE_COLOUR + i, colours[i]);
            }
        }
        return stack;
    }

    public static class_1799 createSingleFromTitleAndText(@Nullable String title, String @Nullable [] text, String @Nullable [] colours) {
        return ((PrintoutItem)((Object)ModRegistry.Items.PRINTED_PAGE.get())).createFromTitleAndText(title, text, colours);
    }

    public static class_1799 createMultipleFromTitleAndText(@Nullable String title, String @Nullable [] text, String @Nullable [] colours) {
        return ((PrintoutItem)((Object)ModRegistry.Items.PRINTED_PAGES.get())).createFromTitleAndText(title, text, colours);
    }

    public static class_1799 createBookFromTitleAndText(@Nullable String title, String @Nullable [] text, String @Nullable [] colours) {
        return ((PrintoutItem)((Object)ModRegistry.Items.PRINTED_BOOK.get())).createFromTitleAndText(title, text, colours);
    }

    public static String getTitle(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_TITLE) ? nbt.method_10558(NBT_TITLE) : "";
    }

    public static int getPageCount(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt != null && nbt.method_10545(NBT_PAGES) ? nbt.method_10550(NBT_PAGES) : 1;
    }

    public static String[] getText(class_1799 stack) {
        return PrintoutItem.getLines(stack, NBT_LINE_TEXT);
    }

    public static String[] getColours(class_1799 stack) {
        return PrintoutItem.getLines(stack, NBT_LINE_COLOUR);
    }

    private static String[] getLines(class_1799 stack, String prefix) {
        class_2487 nbt = stack.method_7969();
        int numLines = PrintoutItem.getPageCount(stack) * 21;
        String[] lines = new String[numLines];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = nbt != null ? nbt.method_10558(prefix + i) : "";
        }
        return lines;
    }
}

