/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public final class PrintoutRecipe
extends class_1852 {
    private final class_1856 leather;
    private final class_1856 string;

    public PrintoutRecipe(class_2960 id, class_7710 category) {
        super(id, category);
        RecipeIngredients ingredients = PlatformHelper.get().getRecipeIngredients();
        this.leather = ingredients.leather();
        this.string = ingredients.string();
    }

    public boolean method_8113(int x, int y) {
        return x >= 3 && y >= 3;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return PrintoutItem.createMultipleFromTitleAndText(null, null, null);
    }

    public boolean matches(class_8566 inventory, class_1937 world) {
        return !this.assemble(inventory, world.method_30349()).method_7960();
    }

    public class_1799 assemble(class_8566 inventory, class_5455 registryAccess) {
        int numPages = 0;
        int numPrintouts = 0;
        class_1799[] printouts = null;
        boolean stringFound = false;
        boolean leatherFound = false;
        boolean printoutFound = false;
        for (int y = 0; y < inventory.method_17397(); ++y) {
            for (int x = 0; x < inventory.method_17398(); ++x) {
                class_1799 stack = inventory.method_5438(x + y * inventory.method_17398());
                if (stack.method_7960()) continue;
                if (stack.method_31574((class_1792)ModRegistry.Items.PRINTED_PAGE.get()) || stack.method_31574((class_1792)ModRegistry.Items.PRINTED_PAGES.get())) {
                    if (printouts == null) {
                        printouts = new class_1799[9];
                    }
                    printouts[numPrintouts] = stack;
                    numPages += PrintoutItem.getPageCount(stack);
                    ++numPrintouts;
                    printoutFound = true;
                    continue;
                }
                if (stack.method_7909() == class_1802.field_8407) {
                    if (printouts == null) {
                        printouts = new class_1799[9];
                    }
                    printouts[numPrintouts] = stack;
                    ++numPages;
                    ++numPrintouts;
                    continue;
                }
                if (this.string.method_8093(stack) && !stringFound) {
                    stringFound = true;
                    continue;
                }
                if (this.leather.method_8093(stack) && !leatherFound) {
                    leatherFound = true;
                    continue;
                }
                return class_1799.field_8037;
            }
        }
        if (numPages <= 16 && stringFound && printoutFound && numPrintouts >= (leatherFound ? 1 : 2)) {
            if (printouts == null) {
                throw new IllegalStateException("Printouts must be non-null");
            }
            String[] text = new String[numPages * 21];
            String[] colours = new String[numPages * 21];
            int line = 0;
            for (int printout = 0; printout < numPrintouts; ++printout) {
                class_1799 stack = printouts[printout];
                if (stack.method_7909() instanceof PrintoutItem) {
                    String[] pageText = PrintoutItem.getText(printouts[printout]);
                    String[] pageColours = PrintoutItem.getColours(printouts[printout]);
                    for (int pageLine = 0; pageLine < pageText.length; ++pageLine) {
                        text[line] = pageText[pageLine];
                        colours[line] = pageColours[pageLine];
                        ++line;
                    }
                    continue;
                }
                for (int pageLine = 0; pageLine < 21; ++pageLine) {
                    text[line] = "";
                    colours[line] = "";
                    ++line;
                }
            }
            String title = null;
            if (printouts[0].method_7909() instanceof PrintoutItem) {
                title = PrintoutItem.getTitle(printouts[0]);
            }
            if (leatherFound) {
                return PrintoutItem.createBookFromTitleAndText(title, text, colours);
            }
            return PrintoutItem.createMultipleFromTitleAndText(title, text, colours);
        }
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRegistry.RecipeSerializers.PRINTOUT.get();
    }
}

