/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay;

import com.vladmarica.betterpingdisplay.Config;
import java.io.File;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterPingDisplayMod
implements ModInitializer {
    public static final String MODID = "betterpingdisplay";
    public static final Logger LOGGER = LogManager.getLogger((String)"betterpingdisplay");
    private static final String CONFIG_FILE_NAME = "betterpingdisplay.json";
    private static BetterPingDisplayMod INSTANCE;
    private Config config = new Config();

    public void onInitialize() {
        INSTANCE = this;
        Path configFilePath = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME);
        File configFile = configFilePath.toFile();
        if (configFile.exists()) {
            try {
                Config.ConfigData data = Config.loadConfigFile(configFile);
                this.config = new Config(data);
                Config.writeConfigFile(configFile, data);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to load config file, using default. Error: {}", (Object)ex.getMessage());
            }
        } else {
            try {
                LOGGER.warn("Could not find config file, creating a default one");
                Config.writeConfigFile(configFile, new Config.ConfigData());
            }
            catch (Exception ex) {
                LOGGER.error("Failed to write default config file. Error: {}", (Object)ex.getMessage());
            }
        }
        LOGGER.info("BetterPingDisplay mod loaded");
    }

    public Config getConfig() {
        return this.config;
    }

    public static BetterPingDisplayMod instance() {
        return INSTANCE;
    }
}

