/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.AbstractPacket;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

public class StopTriggeredEntityAnimPacket
extends AbstractPacket {
    private final int entityId;
    private final boolean isReplacedEntity;
    private final String controllerName;
    private final String animName;

    public StopTriggeredEntityAnimPacket(int entityId, @Nullable String controllerName, @Nullable String animName) {
        this(entityId, false, controllerName, animName);
    }

    public StopTriggeredEntityAnimPacket(int entityId, boolean isReplacedEntity, @Nullable String controllerName, @Nullable String animName) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName == null ? "" : animName;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.entityId);
        buf.writeBoolean(this.isReplacedEntity);
        buf.method_10814(this.controllerName);
        buf.method_10814(this.animName);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return GeckoLibNetwork.STOP_TRIGGERED_ENTITY_ANIM_PACKET_ID;
    }

    public static void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.method_10816();
        boolean isReplacedEntity = buf.readBoolean();
        String controllerName = buf.method_19772();
        String animName = buf.method_19772();
        client.execute(() -> StopTriggeredEntityAnimPacket.runOnThread(entityId, isReplacedEntity, controllerName, animName));
    }

    private static void runOnThread(int entityId, boolean isReplacedEntity, String controllerName, String animName) {
        class_1297 entity = ClientUtils.getLevel().method_8469(entityId);
        if (entity == null) {
            return;
        }
        if (!isReplacedEntity) {
            if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.stopTriggeredAnimation(controllerName.isEmpty() ? null : controllerName, animName);
            }
            return;
        }
        GeoAnimatable geoAnimatable = RenderUtils.getReplacedAnimatable(entity.method_5864());
        if (geoAnimatable instanceof GeoReplacedEntity) {
            GeoReplacedEntity replacedEntity = (GeoReplacedEntity)geoAnimatable;
            replacedEntity.stopTriggeredAnimation(entity, controllerName.isEmpty() ? null : controllerName, animName.isEmpty() ? null : animName);
        }
    }
}

