/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.sodium;

import aztech.modern_industrialization.ModernIndustrialization;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SodiumCompat {
    @Nullable
    private static final MethodHandle METHOD_HANDLE;

    public static void markSpriteActive(class_1058 sprite) {
        if (sprite != null && METHOD_HANDLE != null) {
            try {
                METHOD_HANDLE.invokeExact(sprite);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to invoke SpriteUtil#markSpriteActive", e);
            }
        }
    }

    static {
        MethodHandle handle;
        block2: {
            handle = null;
            try {
                handle = MethodHandles.lookup().findStatic(Class.forName("me.jellysquid.mods.sodium.client.render.texture.SpriteUtil"), "markSpriteActive", MethodType.methodType(Void.TYPE, class_1058.class));
                ModernIndustrialization.LOGGER.info("Loaded Modern Industrialization Sodium active sprite compat.");
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                if (!FabricLoader.getInstance().isModLoaded("sodium")) break block2;
                ModernIndustrialization.LOGGER.error("Failed to load Modern Industrialization Sodium active sprite compat.", (Throwable)e);
            }
        }
        METHOD_HANDLE = handle;
    }
}

