/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLockingClient;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import java.util.Optional;
import java.util.function.Supplier;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.runtime.IJeiRuntime;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
class MachineSlotLockingHandler
implements IRecipeTransferHandler<MachineMenuClient, MachineRecipe> {
    private final Supplier<IJeiRuntime> runtimeSupplier;
    private final RecipeType<MachineRecipe> type;
    private final IRecipeTransferHandlerHelper helper;

    public MachineSlotLockingHandler(IRecipeTransferHandlerHelper helper, Supplier<IJeiRuntime> runtimeSupplier, RecipeType<MachineRecipe> type) {
        this.helper = helper;
        this.runtimeSupplier = runtimeSupplier;
        this.type = type;
    }

    private IRecipeCatalystLookup getLookup() {
        IJeiRuntime runtime = this.runtimeSupplier.get();
        if (runtime != null) {
            return runtime.getRecipeManager().createRecipeCatalystLookup(this.type);
        }
        return null;
    }

    public Class<? extends MachineMenuClient> getContainerClass() {
        return MachineMenuClient.class;
    }

    public Optional<class_3917<MachineMenuClient>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<MachineRecipe> getRecipeType() {
        return this.type;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(MachineMenuClient menu, MachineRecipe recipe, IRecipeSlotsView recipeSlots, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (!this.canApply(menu)) {
            return this.helper.createInternalError();
        }
        ReiSlotLockingClient slotLocking = menu.getComponent(ReiSlotLockingClient.class);
        if (slotLocking == null || !slotLocking.isLockingAllowed()) {
            return this.helper.createInternalError();
        }
        if (doTransfer) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(menu.field_7763);
            buf.method_10812(recipe.method_8114());
            ClientPlayNetworking.send((class_2960)MachinePackets.C2S.REI_LOCK_SLOTS, (class_2540)buf);
        }
        return null;
    }

    private boolean canApply(MachineMenuClient handler) {
        String blockId = handler.guiParams.blockId;
        IRecipeCatalystLookup lookup = this.getLookup();
        if (lookup == null) {
            return false;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223((class_2960)new MIIdentifier(blockId));
        return lookup.getItemStack().anyMatch(is -> is.method_31574(item));
    }
}

