/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.waila.client;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.compat.waila.client.MIWailaClientPlugin;
import aztech.modern_industrialization.compat.waila.client.component.CenteredTextComponent;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.util.FluidHelper;
import java.util.Objects;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.BarComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.SpriteBarComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PipeComponentProvider
implements IBlockComponentProvider {
    @Nullable
    private PipeVoxelShape getHitShape(IBlockAccessor accessor) {
        PipeBlockEntity pipe = (PipeBlockEntity)accessor.getBlockEntity();
        class_243 hitPos = accessor.getHitResult().method_17784();
        class_2338 blockPos = accessor.getPosition();
        for (PipeVoxelShape partShape : pipe.getPartShapes()) {
            class_243 posInBlock = hitPos.method_1023((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            for (class_238 box : partShape.shape.method_1090()) {
                class_243 dir;
                if (!box.method_1006(posInBlock.method_1019(dir = box.method_1005().method_1020(posInBlock).method_1029().method_1021(1.0E-4)))) continue;
                return partShape;
            }
        }
        return null;
    }

    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        PipeVoxelShape shape = this.getHitShape(accessor);
        if (shape != null) {
            class_2561 text = IWailaConfig.get().getFormatter().blockName((Object)class_1074.method_4662((String)MIPipes.INSTANCE.getPipeItem(shape.type).method_7876(), (Object[])new Object[0]));
            tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, text);
        }
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        PipeVoxelShape shape = this.getHitShape(accessor);
        if (shape != null) {
            class_2487 tag = accessor.getData().raw().method_10562(shape.type.getIdentifier().toString());
            if (tag.method_10545("fluid")) {
                FluidVariant fluid = FluidVariant.fromNbt((class_2487)tag.method_10562("fluid"));
                double stored = (double)tag.method_10537("amount") / 81.0;
                double capacity = (double)tag.method_10550("capacity") / 81.0;
                double transfer = (double)tag.method_10537("transfer") / 81.0;
                double maxTransfer = (double)tag.method_10537("maxTransfer") / 81.0;
                if (fluid.isBlank()) {
                    tooltip.addLine((class_2561)MIText.Empty.text());
                } else {
                    class_2561 fluidName = FluidHelper.getFluidName(fluid, true);
                    class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
                    int color = FluidVariantRendering.getColor((FluidVariant)fluid);
                    if (sprite == null) {
                        sprite = Objects.requireNonNull(FluidVariantRendering.getSprite((FluidVariant)FluidVariant.of((class_3611)class_3612.field_15910)));
                    }
                    tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkAmount.text()), (ITooltipComponent)new SpriteBarComponent(MIWailaClientPlugin.ratio(stored, capacity), sprite.method_45852(), sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), 16, 16, color, (class_2561)class_2561.method_43470((String)(MIWailaClientPlugin.fraction(stored, capacity) + " mB")))));
                    tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkFluid.text()), (ITooltipComponent)new CenteredTextComponent(fluidName)));
                    tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkTransfer.text()), (ITooltipComponent)new SpriteBarComponent(MIWailaClientPlugin.ratio(transfer, maxTransfer), sprite.method_45852(), sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), 16, 16, color, (class_2561)class_2561.method_43470((String)(MIWailaClientPlugin.fraction(transfer, maxTransfer) + " mB/t")))));
                }
            }
            if (tag.method_10545("eu")) {
                long stored = tag.method_10537("eu");
                long capacity = tag.method_10537("maxEu");
                long transfer = tag.method_10537("transfer");
                long maxTransfer = tag.method_10537("maxTransfer");
                tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkEnergy.text()), (ITooltipComponent)new BarComponent(MIWailaClientPlugin.ratio(stored, capacity), -4784128, MIWailaClientPlugin.fraction(stored, capacity) + " EU")));
                tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkTier.text()), (ITooltipComponent)new CenteredTextComponent((class_2561)MIPipes.ELECTRICITY_PIPE_TIER.get((Object)MIPipes.INSTANCE.getPipeItem(shape.type)).longEnglishName().method_27696(MITooltips.NUMBER_TEXT))));
                tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkTransfer.text()), (ITooltipComponent)new BarComponent(MIWailaClientPlugin.ratio(transfer, maxTransfer), -4784128, MIWailaClientPlugin.fraction(transfer, maxTransfer) + " EU/t")));
            }
            if (tag.method_10545("items")) {
                long items = tag.method_10537("items");
                int pulse = tag.method_10550("pulse");
                double delay = (double)(60 - pulse) / 20.0;
                double maxDelay = 3.0;
                tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkDelay.text()), (ITooltipComponent)new BarComponent(MIWailaClientPlugin.ratio(delay, maxDelay), -11958, MIWailaClientPlugin.fraction(delay, maxDelay) + " s")));
                tooltip.addLine((ITooltipComponent)new PairComponent((ITooltipComponent)new WrappedComponent((class_2561)MIText.NetworkMovedItems.text()), (ITooltipComponent)new CenteredTextComponent((class_2561)class_2561.method_43470((String)("" + items)).method_27696(MITooltips.NUMBER_TEXT))));
            }
        }
    }
}

