/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public interface ContainerItem<T extends TransferVariant<?>> {
    public T getResource(class_1799 var1);

    public void setResourceNoClean(class_1799 var1, T var2);

    default public void setResource(class_1799 stack, T resource) {
        this.setResourceNoClean(stack, resource);
        this.clean(stack);
    }

    default public boolean isUnlocked(class_1799 stack) {
        if (this.getBehaviour().isLockable()) {
            class_2487 tag = stack.method_7941("BlockEntityTag");
            if (tag == null) {
                return true;
            }
            return !tag.method_10577("locked");
        }
        return true;
    }

    default public void setLockedNoClean(class_1799 stack, boolean locked) {
        if (this.getBehaviour().isLockable()) {
            stack.method_7911("BlockEntityTag").method_10556("locked", locked);
        }
    }

    default public void setLocked(class_1799 stack, boolean locked) {
        this.setLockedNoClean(stack, locked);
        this.clean(stack);
    }

    default public long getAmount(class_1799 stack) {
        if (this.getResource(stack).isBlank()) {
            return 0L;
        }
        if (this.getBehaviour().isCreative()) {
            return Long.MAX_VALUE;
        }
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag == null) {
            return 0L;
        }
        return tag.method_10537("amt");
    }

    default public void setAmountNoClean(class_1799 stack, long amount) {
        if (!this.getBehaviour().isCreative()) {
            stack.method_7911("BlockEntityTag").method_10544("amt", amount);
            this.onChange(stack);
        }
    }

    default public void setAmount(class_1799 stack, long amount) {
        this.setAmountNoClean(stack, amount);
        this.clean(stack);
    }

    default public void clean(class_1799 stack) {
        if (this.isUnlocked(stack) && (this.getResource(stack).isBlank() || this.getAmount(stack) == 0L)) {
            stack.method_7983("BlockEntityTag");
        }
    }

    default public boolean isEmpty(class_1799 stack) {
        if (stack.method_7941("BlockEntityTag") == null) {
            return true;
        }
        return this.getAmount(stack) == 0L;
    }

    default public void onChange(class_1799 stack) {
    }

    public StorageBehaviour<T> getBehaviour();

    public static class GenericItemStorage<T extends TransferVariant<?>>
    implements SingleSlotStorage<T> {
        private final ContainerItemContext context;
        private final ContainerItem<T> containerItem;

        public GenericItemStorage(ContainerItem<T> containerItem, ContainerItemContext context) {
            this.context = context;
            this.containerItem = containerItem;
        }

        public static <T extends TransferVariant<?>> GenericItemStorage<T> of(class_1799 stack, ContainerItem<T> containerItem) {
            class_1277 virtualStackInv = new class_1277(new class_1799[]{stack});
            InventoryStorage virtualStackStorage = InventoryStorage.of((class_1263)virtualStackInv, null);
            ContainerItemContext stackContext = ContainerItemContext.ofSingleSlot((SingleSlotStorage)virtualStackStorage.getSlot(0));
            return new GenericItemStorage<T>(containerItem, stackContext);
        }

        public long insert(T resource, long maxAmount, TransactionContext transaction, boolean ignoreFilter, boolean ignoreLock) {
            StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
            if (this.context.getItemVariant().getItem() != this.containerItem) {
                return 0L;
            }
            if (this.containerItem.getBehaviour().isCreative()) {
                return 0L;
            }
            if ((this.containerItem.getBehaviour().canInsert(resource) || ignoreFilter) && (this.isResourceBlank() && (ignoreLock || this.containerItem.isUnlocked(this.context.getItemVariant().toStack())) || this.getResource().equals(resource))) {
                long amount = this.getAmount();
                long inserted = Math.min(maxAmount, this.containerItem.getBehaviour().getCapacityForResource(resource) - amount);
                if (inserted > 0L && this.context.exchange(this.getUpdatedVariant(this.context.getItemVariant(), resource, amount + inserted), 1L, transaction) == 1L) {
                    return inserted;
                }
            }
            return 0L;
        }

        public long insert(T resource, long maxAmount, TransactionContext transaction) {
            return this.insert(resource, maxAmount, transaction, false, false);
        }

        public long extract(T resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
            if (this.context.getItemVariant().getItem() != this.containerItem) {
                return 0L;
            }
            if (!this.containerItem.getBehaviour().isCreative() && this.containerItem.getBehaviour().canExtract(resource)) {
                if (resource.equals(this.getResource())) {
                    long amount = this.getAmount();
                    long extracted = Math.min(maxAmount, amount);
                    if (extracted > 0L && this.context.exchange(this.getUpdatedVariant(this.context.getItemVariant(), resource, amount - extracted), 1L, transaction) == 1L) {
                        return extracted;
                    }
                    return extracted;
                }
            } else {
                return maxAmount;
            }
            return 0L;
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public T getResource() {
            return this.containerItem.getResource(this.context.getItemVariant().toStack());
        }

        public long getAmount() {
            if (this.isResourceBlank()) {
                return 0L;
            }
            if (!this.containerItem.getBehaviour().isCreative()) {
                return this.containerItem.getAmount(this.context.getItemVariant().toStack());
            }
            return Long.MAX_VALUE;
        }

        public long getCapacity() {
            return this.containerItem.getBehaviour().getCapacityForResource(this.getResource());
        }

        public boolean supportsExtraction() {
            return true;
        }

        public boolean supportsInsertion() {
            return !this.containerItem.getBehaviour().isCreative();
        }

        protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, T newResource, long newAmount) {
            class_1799 stack = currentVariant.toStack();
            this.containerItem.setResourceNoClean(stack, newResource);
            this.containerItem.setAmountNoClean(stack, newAmount);
            this.containerItem.clean(stack);
            return ItemVariant.of((class_1799)stack);
        }
    }
}

