/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.components.IntegerHistoryComponent;
import aztech.modern_industrialization.nuclear.NeutronType;

public class NeutronHistoryComponent
extends IntegerHistoryComponent<Type> {
    public NeutronHistoryComponent() {
        super(Type.class, 100);
    }

    public double getAverageReceived(NeutronType type) {
        if (type == NeutronType.FAST) {
            return this.getAverage(Type.fastNeutronReceived);
        }
        if (type == NeutronType.THERMAL) {
            return this.getAverage(Type.thermalNeutronReceived);
        }
        if (type == NeutronType.BOTH) {
            return this.getAverageReceived(NeutronType.FAST) + this.getAverageReceived(NeutronType.THERMAL);
        }
        return 0.0;
    }

    public double getAverageFlux(NeutronType type) {
        if (type == NeutronType.FAST) {
            return this.getAverage(Type.fastNeutronFlux);
        }
        if (type == NeutronType.THERMAL) {
            return this.getAverage(Type.thermalNeutronFlux);
        }
        if (type == NeutronType.BOTH) {
            return this.getAverageFlux(NeutronType.FAST) + this.getAverageFlux(NeutronType.THERMAL);
        }
        return 0.0;
    }

    public double getAverageGeneration() {
        return this.getAverage(Type.neutronGeneration);
    }

    public double getAverageEuGeneration() {
        return this.getAverage(Type.euGeneration);
    }

    public static enum Type {
        fastNeutronReceived,
        fastNeutronFlux,
        thermalNeutronReceived,
        thermalNeutronFlux,
        neutronGeneration,
        euGeneration;

    }
}

