/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.misc.runtime_datagen;

import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.datagen.dynreg.DynamicRegistryDatagen;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7877;
import net.minecraft.class_7887;
import net.minecraft.class_7923;

public class RuntimeDataGen {
    public static void run(Consumer<FabricDataGenerator.Pack> config) {
        try {
            RuntimeDataGen.runInner(config);
        }
        catch (Exception ex) {
            ModernIndustrialization.LOGGER.error("Failed to runtime datagen", (Throwable)ex);
        }
    }

    private static void runInner(Consumer<FabricDataGenerator.Pack> config) throws Exception {
        Path miFolder = FabricLoader.getInstance().getGameDir().resolve("modern_industrialization");
        Path datagenOverridesFolder = miFolder.resolve("extra_datagen_resources");
        Files.createDirectories(datagenOverridesFolder.resolve("assets").resolve("modern_industrialization").resolve("textures"), new FileAttribute[0]);
        Files.createDirectories(datagenOverridesFolder.resolve("assets").resolve("modern_industrialization").resolve("datagen_texture_overrides"), new FileAttribute[0]);
        Path dataOutput = miFolder.resolve("runtime_datagen");
        ModernIndustrialization.LOGGER.info("Starting MI runtime data generation");
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("modern_industrialization").get();
        CompletableFuture<class_7225.class_7874> registriesFuture = CompletableFuture.supplyAsync(() -> {
            class_7877 vanillaBuilder = class_7887.field_40953;
            DynamicRegistryDatagen.run(vanillaBuilder);
            HashMap<class_5321, List> map = new HashMap<class_5321, List>();
            for (class_7877.class_7884 entry : vanillaBuilder.field_40941) {
                map.computeIfAbsent(entry.comp_1144(), k -> new ArrayList()).add(entry.comp_1146());
            }
            class_7877 combinedBuilder = new class_7877();
            for (Map.Entry entry : map.entrySet()) {
                combinedBuilder.method_46777((class_5321)entry.getKey(), ctx -> {
                    for (class_7877.class_7882 bootstrap : (List)entry.getValue()) {
                        bootstrap.run(ctx);
                    }
                });
            }
            return combinedBuilder.method_46780((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167));
        }, class_156.method_18349());
        FabricDataGenerator gen = new FabricDataGenerator(dataOutput, modContainer, true, registriesFuture);
        config.accept(gen.createPack());
        gen.method_10315();
        ModernIndustrialization.LOGGER.info("Starting MI runtime pack calculation");
        Path cleanedOutput = miFolder.resolve("generated_resources");
        if (Files.exists(cleanedOutput, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(cleanedOutput, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        try (Stream<Path> cacheStream = Files.walk(dataOutput.resolve(".cache"), 1, new FileVisitOption[0]);){
            cacheStream.forEach(cachePath -> {
                if (Files.isDirectory(cachePath, new LinkOption[0])) {
                    return;
                }
                Map<String, String> newCache = RuntimeDataGen.readCache(cachePath);
                Map<String, String> oldCache = RuntimeDataGen.readCache((Path)modContainer.findPath(".cache/" + cachePath.getFileName()).get());
                for (Map.Entry<String, String> newEntry : newCache.entrySet()) {
                    String oldHash = oldCache.get(newEntry.getKey());
                    if (newEntry.getValue().equals(oldHash)) continue;
                    Path newPath = cleanedOutput.resolve(newEntry.getKey());
                    try {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        Files.copy(dataOutput.resolve(newEntry.getKey()), newPath, new CopyOption[0]);
                    }
                    catch (IOException e) {
                        ModernIndustrialization.LOGGER.error("Failed to copy file " + newEntry.getKey(), (Throwable)e);
                    }
                }
            });
        }
        ModernIndustrialization.LOGGER.info("Successfully finished MI runtime data generation");
    }

    private static Map<String, String> readCache(Path path) {
        HashMap<String, String> hashMap;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                reader.readLine();
                reader.lines().forEach(line -> {
                    String[] parts = line.split(" ", 2);
                    map.put(parts[1], parts[0]);
                });
                hashMap = map;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ModernIndustrialization.LOGGER.warn("Failed to read cache file " + path, (Throwable)e);
                    return Map.of();
                }
            }
            reader.close();
        }
        return hashMap;
    }
}

