/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class NuclearAbsorbable
extends NuclearComponentItem {
    public final int desintegrationMax;

    public NuclearAbsorbable(FabricItemSettings settings, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour, int desintegrationMax) {
        super((class_1792.class_1793)settings, maxTemperature, heatConduction, neutronBehaviour);
        this.desintegrationMax = desintegrationMax;
    }

    public void setRemainingDesintegrations(class_1799 stack, int value) {
        if (value < 0 || value > this.desintegrationMax) {
            throw new IllegalArgumentException(String.format("Remaining desintegration %d must be between 0 and max desintegration = %d", value, this.desintegrationMax));
        }
        class_2487 tag = stack.method_7948();
        tag.method_10569("desRem", value);
    }

    public static NuclearComponentItem of(String englishName, String id, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour, int desintegrationMax) {
        return MIItem.item(englishName, id, settings -> new NuclearAbsorbable(settings.maxCount(1), maxTemperature, heatConduction, neutronBehaviour, desintegrationMax), SortOrder.ITEMS_OTHER).method_8389();
    }

    public double getDurabilityBarProgress(class_1799 stack) {
        return (double)this.getRemainingDesintegrations(stack) / (double)this.desintegrationMax;
    }

    public int method_31571(class_1799 stack) {
        float f = (float)this.getRemainingDesintegrations(stack) / (float)this.desintegrationMax;
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean method_31567(class_1799 stack) {
        return this.getRemainingDesintegrations(stack) != this.desintegrationMax;
    }

    public int method_31569(class_1799 stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public int getRemainingDesintegrations(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545("desRem")) {
            return this.desintegrationMax;
        }
        return tag.method_10550("desRem");
    }

    protected static int randIntFromDouble(double value, class_5819 rand) {
        return (int)Math.floor(value) + (rand.method_43058() < value % 1.0 ? 1 : 0);
    }

    public int simulateAbsorption(double neutronsReceived, class_1799 stack, class_5819 rand) {
        int absorbNeutrons = Math.min(NuclearAbsorbable.randIntFromDouble(neutronsReceived, rand), this.getRemainingDesintegrations(stack));
        this.setRemainingDesintegrations(stack, this.getRemainingDesintegrations(stack) - absorbNeutrons);
        return absorbNeutrons;
    }
}

