/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block.recipes;

import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytSlot;
import appeng.client.guidebook.document.block.LytSlotGrid;
import appeng.client.guidebook.document.block.recipes.LytRecipeBox;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import appeng.core.AppEng;
import appeng.siteexport.ExportableResourceProvider;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_8059;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LytSmithingRecipe
extends LytRecipeBox
implements ExportableResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LytSmithingRecipe.class);
    private static final class_2960 ARROW_LIGHT = AppEng.makeId("ae2guide/gui/recipe_arrow_light.png");
    private static final class_2960 ARROW_DARK = AppEng.makeId("ae2guide/gui/recipe_arrow_dark.png");
    private final class_8059 recipe;
    private final LytSlotGrid inputGrid;
    private final LytSlot resultSlot;

    public LytSmithingRecipe(class_8059 recipe) {
        super((class_1860<?>)recipe);
        this.recipe = recipe;
        this.setPadding(5);
        this.paddingTop = 15;
        this.inputGrid = LytSlotGrid.row(LytSmithingRecipe.getIngredients(recipe), true);
        this.append(this.inputGrid);
        this.resultSlot = new LytSlot(recipe.method_8110(Platform.getClientRegistryAccess()));
        this.append(this.resultSlot);
    }

    @NotNull
    private static List<class_1856> getIngredients(class_8059 recipe) {
        if (recipe instanceof class_8062) {
            class_8062 trimRecipe = (class_8062)recipe;
            return List.of(trimRecipe.field_42035, trimRecipe.field_42036, trimRecipe.field_42037);
        }
        if (recipe instanceof class_8060) {
            class_8060 transformRecipe = (class_8060)recipe;
            return List.of(transformRecipe.field_42030, transformRecipe.field_42031, transformRecipe.field_42032);
        }
        LOG.warn("Cannot determine ingredients of smithing recipe type {}", recipe.getClass());
        return List.of();
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect inputBounds = this.inputGrid.layout(context, x, y, availableWidth);
        LytRect resultBounds = this.resultSlot.layout(context, inputBounds.right() + 28, y, availableWidth);
        return LytRect.union(inputBounds, resultBounds);
    }

    @Override
    public void render(RenderContext context) {
        context.renderPanel(this.getBounds());
        context.renderItem(class_2246.field_16329.method_8389().method_7854(), this.bounds.x() + this.paddingLeft, this.bounds.y() + 4, 8.0f, 8.0f);
        context.renderText(class_1802.field_16308.method_7848().getString(), DefaultStyles.CRAFTING_RECIPE_TYPE.mergeWith(DefaultStyles.BASE_STYLE), this.bounds.x() + this.paddingLeft + 10, this.bounds.y() + 4);
        context.fillTexturedRect(new LytRect(this.bounds.right() - 25 - 24, this.bounds.y() + 10 + (this.bounds.height() - 27) / 2, 24, 17), context.isDarkMode() ? ARROW_DARK : ARROW_LIGHT);
        super.render(context);
    }
}

