/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.execution;

import appeng.api.config.Actionable;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.CraftingLink;
import appeng.crafting.execution.CraftingCpuLogic;
import appeng.crafting.execution.ElapsedTimeTracker;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.service.CraftingService;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class ExecutingCraftingJob {
    private static final String NBT_LINK = "link";
    private static final String NBT_PLAYER_ID = "playerId";
    private static final String NBT_FINAL_OUTPUT = "finalOutput";
    private static final String NBT_WAITING_FOR = "waitingFor";
    private static final String NBT_TIME_TRACKER = "timeTracker";
    private static final String NBT_REMAINING_AMOUNT = "remainingAmount";
    private static final String NBT_TASKS = "tasks";
    private static final String NBT_CRAFTING_PROGRESS = "#craftingProgress";
    final CraftingLink link;
    final ListCraftingInventory waitingFor;
    final Map<IPatternDetails, TaskProgress> tasks = new HashMap<IPatternDetails, TaskProgress>();
    final ElapsedTimeTracker timeTracker;
    GenericStack finalOutput;
    long remainingAmount;
    @Nullable
    Integer playerId;

    ExecutingCraftingJob(ICraftingPlan plan, CraftingDifferenceListener postCraftingDifference, CraftingLink link, @Nullable Integer playerId) {
        this.finalOutput = plan.finalOutput();
        this.remainingAmount = this.finalOutput.amount();
        this.waitingFor = new ListCraftingInventory(postCraftingDifference::onCraftingDifference);
        this.timeTracker = new ElapsedTimeTracker();
        for (Object2LongMap.Entry<AEKey> entry : plan.emittedItems()) {
            this.waitingFor.insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE);
            this.timeTracker.addMaxItems(entry.getLongValue(), ((AEKey)entry.getKey()).getType());
        }
        for (Map.Entry entry : plan.patternTimes().entrySet()) {
            this.tasks.computeIfAbsent((IPatternDetails)((IPatternDetails)entry.getKey()), (Function<IPatternDetails, TaskProgress>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$new$0(appeng.api.crafting.IPatternDetails ), (Lappeng/api/crafting/IPatternDetails;)Lappeng/crafting/execution/ExecutingCraftingJob$TaskProgress;)()).value += ((Long)entry.getValue()).longValue();
            for (GenericStack output : ((IPatternDetails)entry.getKey()).getOutputs()) {
                long amount = output.amount() * (Long)entry.getValue() * (long)output.what().getAmountPerUnit();
                this.timeTracker.addMaxItems(amount, output.what().getType());
            }
        }
        this.link = link;
        this.playerId = playerId;
    }

    ExecutingCraftingJob(class_2487 data, CraftingDifferenceListener postCraftingDifference, CraftingCpuLogic cpu) {
        this.link = new CraftingLink(data.method_10562(NBT_LINK), cpu.cluster);
        IGrid grid = cpu.cluster.getGrid();
        if (grid != null) {
            ((CraftingService)grid.getCraftingService()).addLink(this.link);
        }
        this.finalOutput = GenericStack.readTag(data.method_10562(NBT_FINAL_OUTPUT));
        this.remainingAmount = data.method_10537(NBT_REMAINING_AMOUNT);
        this.waitingFor = new ListCraftingInventory(postCraftingDifference::onCraftingDifference);
        this.waitingFor.readFromNBT(data.method_10554(NBT_WAITING_FOR, 10));
        this.timeTracker = new ElapsedTimeTracker(data.method_10562(NBT_TIME_TRACKER));
        this.playerId = data.method_10573(NBT_PLAYER_ID, 3) ? Integer.valueOf(data.method_10550(NBT_PLAYER_ID)) : null;
        class_2499 tasksTag = data.method_10554(NBT_TASKS, 10);
        for (int i = 0; i < tasksTag.size(); ++i) {
            class_2487 item = tasksTag.method_10602(i);
            AEItemKey pattern = AEItemKey.fromTag(item);
            IPatternDetails details = PatternDetailsHelper.decodePattern(pattern, cpu.cluster.getLevel());
            if (details == null) continue;
            TaskProgress tp = new TaskProgress();
            tp.value = item.method_10537(NBT_CRAFTING_PROGRESS);
            this.tasks.put(details, tp);
        }
    }

    class_2487 writeToNBT() {
        class_2487 data = new class_2487();
        class_2487 linkData = new class_2487();
        this.link.writeToNBT(linkData);
        data.method_10566(NBT_LINK, (class_2520)linkData);
        data.method_10566(NBT_FINAL_OUTPUT, (class_2520)GenericStack.writeTag(this.finalOutput));
        data.method_10566(NBT_WAITING_FOR, (class_2520)this.waitingFor.writeToNBT());
        data.method_10566(NBT_TIME_TRACKER, (class_2520)this.timeTracker.writeToNBT());
        class_2499 list = new class_2499();
        for (Map.Entry<IPatternDetails, TaskProgress> e : this.tasks.entrySet()) {
            class_2487 item = e.getKey().getDefinition().toTag();
            item.method_10544(NBT_CRAFTING_PROGRESS, e.getValue().value);
            list.add((Object)item);
        }
        data.method_10566(NBT_TASKS, (class_2520)list);
        data.method_10544(NBT_REMAINING_AMOUNT, this.remainingAmount);
        if (this.playerId != null) {
            data.method_10569(NBT_PLAYER_ID, this.playerId.intValue());
        }
        return data;
    }

    private static /* synthetic */ TaskProgress lambda$new$0(IPatternDetails p) {
        return new TaskProgress();
    }

    @FunctionalInterface
    static interface CraftingDifferenceListener {
        public void onCraftingDifference(AEKey var1);
    }

    static class TaskProgress {
        long value = 0L;

        TaskProgress() {
        }
    }
}

