/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.blocks;

import appeng.api.client.AEKeyRendering;
import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.InGameTooltip;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class PatternProviderDataProvider
implements BodyProvider<PatternProviderLogicHost>,
ServerDataProvider<PatternProviderLogicHost> {
    private static final String NBT_LOCK_REASON = "craftingLockReason";
    private static final String NBT_LOCK_UNTIL_RESULT_STACK = "craftingLockUntilResultStack";

    @Override
    public void buildTooltip(PatternProviderLogicHost host, TooltipContext context, TooltipBuilder tooltip) {
        class_2487 stack;
        String lockReason = context.serverData().method_10558(NBT_LOCK_REASON);
        if (!lockReason.isEmpty()) {
            tooltip.addLine((class_2561)class_2561.class_2562.method_10877((String)lockReason));
        }
        if (!(stack = context.serverData().method_10562(NBT_LOCK_UNTIL_RESULT_STACK)).method_33133()) {
            class_5250 stackAmount;
            class_5250 stackName;
            GenericStack genericStack = GenericStack.readTag(stack);
            if (genericStack == null) {
                stackName = class_2561.method_43470((String)"ERROR");
                stackAmount = class_2561.method_43470((String)"ERROR");
            } else {
                stackName = AEKeyRendering.getDisplayName(genericStack.what());
                stackAmount = class_2561.method_43470((String)genericStack.what().formatAmount(genericStack.amount(), AmountFormat.FULL));
            }
            tooltip.addLine((class_2561)InGameTooltip.CraftingLockedUntilResult.text(stackName, stackAmount).method_27692(class_124.field_1061));
        }
    }

    @Override
    public void provideServerData(class_1657 player, PatternProviderLogicHost host, class_2487 serverData) {
        PatternProviderLogic logic = host.getLogic();
        class_5250 reason = null;
        switch (logic.getCraftingLockedReason()) {
            case LOCK_UNTIL_PULSE: {
                reason = InGameTooltip.CraftingLockedUntilPulse.text();
                break;
            }
            case LOCK_WHILE_HIGH: {
                reason = InGameTooltip.CraftingLockedByRedstoneSignal.text();
                break;
            }
            case LOCK_WHILE_LOW: {
                reason = InGameTooltip.CraftingLockedByLackOfRedstoneSignal.text();
                break;
            }
            case LOCK_UNTIL_RESULT: {
                GenericStack stack = logic.getUnlockStack();
                if (stack != null) {
                    serverData.method_10566(NBT_LOCK_UNTIL_RESULT_STACK, (class_2520)GenericStack.writeTag(stack));
                } else {
                    class_2487 errorDummy = new class_2487();
                    errorDummy.method_10582("error", "error");
                    serverData.method_10566(NBT_LOCK_UNTIL_RESULT_STACK, (class_2520)errorDummy);
                }
                return;
            }
        }
        if (reason != null) {
            serverData.method_10582(NBT_LOCK_REASON, class_2561.class_2562.method_10867((class_2561)reason.method_27661().method_27692(class_124.field_1061)));
        }
    }
}

